/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.processor;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.builder.AnnotationBuilder;
import java.util.List;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;

public class ElementAnnotationProcessor
extends AbstractProcessor<CtElement> {
    private final AnnotationService service;
    private final List<AnnotationBuilder<?, ?>> annotationBuilders;
    private final Set<Class<? extends CtElement>> scannedTypes = Set.of(CtAbstractInvocation.class, CtExecutable.class);

    public ElementAnnotationProcessor(AnnotationService service, List<AnnotationBuilder<?, ?>> annotationBuilders) {
        this.service = service;
        this.annotationBuilders = annotationBuilders;
    }

    public void process(CtElement element) {
        if (this.scannedTypes.stream().noneMatch(clazz -> clazz.isAssignableFrom(element.getClass()))) {
            return;
        }
        CtElement finalElement = this.transform(element);
        for (AnnotationBuilder<?, ?> builder : this.annotationBuilders) {
            List<Annotation> annotation = builder.annotate(finalElement);
            if (annotation == null) continue;
            annotation.forEach(ann -> this.service.addAnnotation(element, (Annotation)ann));
        }
    }

    private CtElement transform(CtElement element) {
        if (element instanceof CtExecutable) {
            return ((CtExecutable)element).getReference();
        }
        if (element instanceof CtAbstractInvocation) {
            return ((CtAbstractInvocation)element).getExecutable();
        }
        return element;
    }
}

