/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.matcher.builder;

import com.pvsstudio.annotation.matcher.ClassMatcher;
import com.pvsstudio.annotation.matcher.ExecutableMatcher;
import com.pvsstudio.annotation.matcher.builder.MatcherBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class ExecutableMatcherBuilder
implements MatcherBuilder<CtExecutableReference<?>> {
    private static final Predicate<CtExecutableReference<?>> ANY_PARAMETERS = ctMethod -> true;
    private final ClassMatcher classMatcher;
    private final Predicate<CtExecutableReference<?>> predicate;
    private Predicate<CtExecutableReference<?>> parametersPredicate;
    private final String[] methodName;

    public ExecutableMatcherBuilder(String methodName) {
        this.classMatcher = new ClassMatcher(type -> true);
        this.predicate = ctExecutable -> ctExecutable.getSimpleName().equals(methodName);
        this.methodName = new String[]{methodName};
    }

    public ExecutableMatcherBuilder(ClassMatcher classMatcher, String ... methodName) {
        this.classMatcher = classMatcher;
        this.predicate = ctExecutable -> {
            CtTypeReference declaringType = ctExecutable.getDeclaringType();
            String executableName = ctExecutable.getSimpleName();
            if (declaringType != null) {
                return StringUtils.equalsAny((CharSequence)executableName, (CharSequence[])methodName) && this.classMatcher.matches(declaringType);
            }
            return false;
        };
        this.methodName = methodName;
    }

    public ExecutableMatcherBuilder anyParameters() {
        if (this.parametersPredicate != null) {
            throw new IllegalStateException("Cannot use 'anyParameters' when parameters are already specified.");
        }
        this.parametersPredicate = ANY_PARAMETERS;
        return this;
    }

    public ExecutableMatcherBuilder parameters(String ... types) {
        if (Objects.equals(this.parametersPredicate, ANY_PARAMETERS)) {
            throw new IllegalStateException("Cannot add parameter matching after 'anyParameters'.");
        }
        Predicate<CtExecutableReference> newPredicate = ctExecutable -> {
            List parameters = ctExecutable.getParameters();
            int parametersSize = parameters.size();
            if (types.length != parametersSize) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                CtTypeReference typeReference;
                CtTypeReference parameter;
                String type = types[i];
                if (type.equals("<any>") || (parameter = (CtTypeReference)parameters.get(i)).equals((Object)(typeReference = parameter.getFactory().Type().createReference(type)))) continue;
                return false;
            }
            return true;
        };
        this.parametersPredicate = this.parametersPredicate == null ? newPredicate : this.parametersPredicate.or(newPredicate);
        return this;
    }

    public ExecutableMatcher build() {
        if (this.parametersPredicate == null) {
            throw new IllegalStateException("Method matcher requires specifying parameters. Use anyParameters() if they don't matter.");
        }
        Predicate<CtExecutableReference<?>> finalPredicate = this.predicate.and(this.parametersPredicate);
        return new ExecutableMatcher(this.classMatcher, finalPredicate);
    }

    public String toString() {
        return String.format("Methods: %s", Arrays.toString(this.methodName));
    }
}

