/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.matcher.builder;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.pvsstudio.annotation.matcher.ClassMatcher;
import com.pvsstudio.annotation.matcher.builder.InvocationMatcherBuilder;
import com.pvsstudio.annotation.matcher.builder.MatcherBuilder;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.SpoonClassNotFoundException;

public class ClassMatcherBuilder
implements MatcherBuilder<CtTypeReference<?>> {
    private final String className;
    private Predicate<CtTypeReference<?>> classPredicate;

    public ClassMatcherBuilder(String className) {
        this.className = className;
        this.classPredicate = ctClass -> ctClass.getQualifiedName().equals(className);
    }

    public InvocationMatcherBuilder ofMethod(String ... methodNames) {
        return new InvocationMatcherBuilder(this.build(), methodNames);
    }

    public ClassMatcherBuilder includeSubtypes() {
        CacheLoader loader = new CacheLoader<CtTypeReference<?>, Boolean>(){

            @NotNull
            public Boolean load(@NotNull CtTypeReference<?> ctClass) {
                try {
                    CtTypeReference typeErasure = ctClass.getDeclaration() != null ? ctClass.getTypeErasure() : ctClass;
                    CtTypeReference type = ctClass.getFactory().Type().createReference(ClassMatcherBuilder.this.className);
                    if (type.equals((Object)typeErasure)) {
                        return true;
                    }
                    if (type.isInterface()) {
                        if (ctClass.getSuperInterfaces().contains(type)) {
                            return true;
                        }
                        return typeErasure.isSubtypeOf(type);
                    }
                    if (typeErasure.getSuperclass() != null && typeErasure.getSuperclass().getQualifiedName().equals(type.getQualifiedName())) {
                        return true;
                    }
                    if (ctClass.isPrimitive()) {
                        return false;
                    }
                    return typeErasure.isSubtypeOf(type);
                }
                catch (SpoonClassNotFoundException e) {
                    return false;
                }
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().build(loader);
        this.classPredicate = arg_0 -> ((LoadingCache)cache).getUnchecked(arg_0);
        return this;
    }

    public ClassMatcher build() {
        return new ClassMatcher(this.classPredicate);
    }
}

