/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.matcher;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.reflect.TypeToken;
import com.pvsstudio.annotation.matcher.builder.ClassMatcherBuilder;
import com.pvsstudio.annotation.matcher.builder.InvocationMatcherBuilder;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtElement;

public class Matcher<T extends CtElement> {
    private final Class<?> type;
    protected final Predicate<T> predicate;
    private static Cache<String, ClassMatcherBuilder> cache = CacheBuilder.newBuilder().build();

    public Matcher(Predicate<T> predicate) {
        this.predicate = predicate;
        this.type = new TypeToken<T>(this.getClass()){}.getRawType();
    }

    public static ClassMatcherBuilder ofClass(String className) {
        try {
            return (ClassMatcherBuilder)cache.get((Object)className, () -> new ClassMatcherBuilder(className));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassMatcherBuilder ofClass(Class<?> clazz) {
        return new ClassMatcherBuilder(clazz.getCanonicalName());
    }

    public static InvocationMatcherBuilder ofMethod(String methodName) {
        return new InvocationMatcherBuilder(methodName);
    }

    public boolean matches(@NotNull T e) {
        if (this.type.isAssignableFrom(e.getClass())) {
            return this.predicate.test(e);
        }
        return false;
    }
}

