/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.declaration;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.pvsstudio.annotation.declaration.annotation.AnnotationDeclaration;
import com.pvsstudio.annotation.declaration.annotation.AnnotationMatcher;
import com.pvsstudio.annotation.matcher.builder.MatcherBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class MatcherProvider
implements Provider<Map<String, List<MatcherBuilder<?>>>> {
    private final Injector injector;

    @Inject
    public MatcherProvider(Injector injector) {
        this.injector = injector;
    }

    public Map<String, List<MatcherBuilder<?>>> get() {
        HashMap map = new HashMap();
        for (Binding binding : this.injector.getAllBindings().values()) {
            TypeLiteral typeLiteral = binding.getKey().getTypeLiteral();
            Class clazz = typeLiteral.getRawType();
            if (!clazz.isAnnotationPresent(AnnotationDeclaration.class)) continue;
            AnnotationDeclaration declaration = clazz.getAnnotation(AnnotationDeclaration.class);
            Object instance = this.injector.getInstance(binding.getKey());
            List<Field> fields = Stream.of(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AnnotationMatcher.class)).collect(Collectors.toList());
            if (fields.isEmpty()) {
                throw new IllegalStateException("Declaration class for annotations does not contain a single field annotated with @AnnotationMatcher");
            }
            fields.forEach(field -> {
                field.setAccessible(true);
                try {
                    MatcherBuilder matcher = (MatcherBuilder)field.get(instance);
                    AnnotationMatcher annotation = field.getAnnotation(AnnotationMatcher.class);
                    String group = Optional.of(annotation.value()).filter(StringUtils::isNotEmpty).orElse(declaration.value());
                    if (StringUtils.isEmpty((CharSequence)group)) {
                        throw new IllegalStateException(String.format("No group specified in both @AnnotationDeclaration and @AnnotationMatcher for field %s", field.getName()));
                    }
                    map.computeIfAbsent(group, ignore -> new ArrayList()).add(matcher);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return map;
    }
}

