/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.builder;

import com.google.common.base.Suppliers;
import com.pvsstudio.annotation.builder.AnnotationBuilder;
import com.pvsstudio.annotation.builder.ClassAnnotationBuilder;
import com.pvsstudio.annotation.matcher.ExecutableMatcher;
import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.annotation.matcher.builder.ExecutableMatcherBuilder;
import java.util.List;
import java.util.function.Supplier;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;

public class MethodAnnotationBuilder
extends AnnotationBuilder<CtExecutableReference<?>, MethodAnnotationBuilder> {
    private final Supplier<ExecutableMatcher> executableMatcher;
    private final ClassAnnotationBuilder classMatcher;
    private final String methodName;
    private ExecutableMatcherBuilder invocationMatcherBuilder;

    public MethodAnnotationBuilder(ClassAnnotationBuilder classMatcher, String methodName) {
        this.methodName = methodName;
        this.classMatcher = classMatcher;
        this.invocationMatcherBuilder = Matcher.ofMethod(methodName).matchExecutables();
        this.executableMatcher = Suppliers.memoize(this.invocationMatcherBuilder::build);
    }

    public MethodAnnotationBuilder anyParameters() {
        this.invocationMatcherBuilder = this.invocationMatcherBuilder.anyParameters();
        return this;
    }

    public MethodAnnotationBuilder parameters(String ... types) {
        this.invocationMatcherBuilder = this.invocationMatcherBuilder.parameters(types);
        return this;
    }

    public MethodAnnotationBuilder ofMethod(String methodName) {
        return this.classMatcher.ofMethod(methodName);
    }

    @Override
    protected boolean matches(CtElement element) {
        if (!(element instanceof CtExecutableReference)) {
            return false;
        }
        CtExecutableReference reference = (CtExecutableReference)element;
        return this.executableMatcher.get().matches(reference) && this.classMatcher.matches((CtElement)reference.getDeclaringType());
    }

    @Override
    public List<AnnotationBuilder<?, ?>> finish() {
        return this.classMatcher.finish();
    }

    public String toString() {
        return String.format("%s#%s", this.classMatcher.toString(), this.methodName);
    }
}

