/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.builder;

import com.google.common.base.Suppliers;
import com.pvsstudio.annotation.builder.AnnotationBuilder;
import com.pvsstudio.annotation.builder.MethodAnnotationBuilder;
import com.pvsstudio.annotation.matcher.ClassMatcher;
import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.annotation.matcher.builder.ClassMatcherBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class ClassAnnotationBuilder
extends AnnotationBuilder<CtTypeReference<?>, ClassAnnotationBuilder> {
    private final Supplier<ClassMatcher> classMatcher;
    private final List<MethodAnnotationBuilder> methodAnnotationBuilders = new ArrayList<MethodAnnotationBuilder>();
    private final String className;
    private ClassMatcherBuilder classMatcherBuilder;

    protected ClassAnnotationBuilder(String className) {
        this.className = className;
        this.classMatcherBuilder = Matcher.ofClass(className);
        this.classMatcher = Suppliers.memoize(this.classMatcherBuilder::build);
    }

    public ClassAnnotationBuilder includeSubtypes() {
        this.classMatcherBuilder = this.classMatcherBuilder.includeSubtypes();
        return this;
    }

    public MethodAnnotationBuilder ofMethod(String methodName) {
        MethodAnnotationBuilder methodBuilder = new MethodAnnotationBuilder(this, methodName);
        this.methodAnnotationBuilders.add(methodBuilder);
        return methodBuilder;
    }

    @Override
    public List<AnnotationBuilder<?, ?>> finish() {
        ArrayList builders = new ArrayList();
        builders.add(this);
        builders.addAll(this.methodAnnotationBuilders);
        return builders;
    }

    @Override
    protected boolean matches(CtElement element) {
        if (!(element instanceof CtTypeReference)) {
            return false;
        }
        return this.classMatcher.get().matches((CtTypeReference)element);
    }

    public String toString() {
        return this.className;
    }
}

