/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation.builder;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.annotation.builder.ClassAnnotationBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import spoon.reflect.declaration.CtElement;

public abstract class AnnotationBuilder<T extends CtElement, A extends AnnotationBuilder<T, A>> {
    private final List<Annotation> flags = new ArrayList<Annotation>();
    private Function<T, List<Annotation>> onMatch;

    public static ClassAnnotationBuilder ofClass(String className) {
        return new ClassAnnotationBuilder(className);
    }

    public static ClassAnnotationBuilder ofClass(Class<?> clazz) {
        String matcher = clazz.getCanonicalName();
        return new ClassAnnotationBuilder(matcher);
    }

    public A onMatch(Function<T, List<Annotation>> onMatch) {
        this.onMatch = onMatch;
        return (A)this;
    }

    public A flags(FlagAnnotation ... annotations) {
        this.flags.addAll(List.of(annotations));
        return (A)this;
    }

    public A flags(Collection<FlagAnnotation> annotations) {
        this.flags.addAll(annotations);
        return (A)this;
    }

    public List<Annotation> annotate(CtElement element) {
        boolean matched = this.matches(element);
        CtElement actualElement = element;
        if (matched) {
            ArrayList<Annotation> result = new ArrayList<Annotation>(this.flags);
            if (this.onMatch != null) {
                result.addAll((Collection<Annotation>)this.onMatch.apply(actualElement));
            }
            return result;
        }
        return null;
    }

    public abstract Collection<? extends AnnotationBuilder<?, ?>> finish();

    protected abstract boolean matches(CtElement var1);
}

