/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.annotation;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Annotations {
    private final EnumSet<FlagAnnotation> flags = EnumSet.noneOf(FlagAnnotation.class);
    private final Set<Annotation> customAnnotations = new HashSet<Annotation>();
    private static final Annotations EMPTY_ANNOTATIONS = new Annotations();

    public static Annotations empty() {
        return EMPTY_ANNOTATIONS;
    }

    public boolean contains(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (annotation instanceof FlagAnnotation) {
            return this.flags.contains(annotation);
        }
        return this.customAnnotations.contains(annotation);
    }

    public void remove(@NotNull Annotation annotation) {
        if (annotation instanceof FlagAnnotation) {
            this.flags.remove(annotation);
        } else {
            this.customAnnotations.remove(annotation);
        }
    }

    public void add(@NotNull Annotation annotation) {
        if (annotation instanceof FlagAnnotation) {
            this.flags.add((FlagAnnotation)annotation);
        } else {
            this.customAnnotations.add(annotation);
        }
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.flags.isEmpty() && this.customAnnotations.isEmpty();
    }

    public Set<Annotation> getCustomAnnotations() {
        return Set.copyOf(this.customAnnotations);
    }

    public String toString() {
        return "Annotations{flags=" + String.valueOf(this.flags) + ", customAnnotations=" + String.valueOf(this.customAnnotations) + "}";
    }
}

