/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.util.path;

import com.pvsstudio.util.path.PathResolverImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

class ProjectRelativePathResolver
extends PathResolverImpl {
    private final String projectPath;

    public ProjectRelativePathResolver(@NotNull String projectPath) {
        this.projectPath = projectPath;
    }

    @Override
    public String resolveAbsolutePath(@NotNull String path) {
        if (Paths.get(path, new String[0]).isAbsolute() || path.startsWith("~")) {
            return super.resolveAbsolutePath(path);
        }
        try {
            path = new File(this.projectPath, path).getCanonicalPath();
        }
        catch (IOException ignored) {
            path = new File(this.projectPath, path).getAbsolutePath();
        }
        return this.normalizePath(path);
    }
}

