/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.util.path;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.util.path.PathResolverImpl;
import com.pvsstudio.util.path.ProjectRelativePathResolver;
import org.jetbrains.annotations.NotNull;

public interface PathResolver {
    public String resolveAbsolutePath(@NotNull String var1);

    default public String normalizePath(@NotNull String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replace("\\", "/");
    }

    public static PathResolver forConfig(AnalyzerConfig config) {
        if (config.launchMode == AnalyzerConfig.LaunchMode.GRADLE || config.launchMode == AnalyzerConfig.LaunchMode.IDEA || config.launchMode == AnalyzerConfig.LaunchMode.VSCODE) {
            return new ProjectRelativePathResolver(config.projectPath);
        }
        return new PathResolverImpl();
    }
}

