/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.util.exclude;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.util.path.PathResolver;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ExcludeResolver {
    private final AnalyzerConfig config;

    public ExcludeResolver(AnalyzerConfig config) {
        this.config = config;
    }

    public boolean isExcludedByAnalyzeOnly(String path) {
        return !this.config.analyzeOnly.isEmpty() && this.config.analyzeOnly.stream().noneMatch(r -> this.isRelative(path, (String)r, true));
    }

    public boolean isExcludedByExclude(String path, boolean calcAbsolutePaths) {
        return !this.config.exclude.isEmpty() && this.config.exclude.stream().anyMatch(r -> this.isRelative(path, (String)r, calcAbsolutePaths));
    }

    public boolean isExcludedByAutoGeneratedComment(List<String> lines) {
        return lines.size() > 2 && (lines.get(0).contains("Generated by the protocol buffer compiler.") || lines.get(1).contains("automatically generated by SWIG") || lines.get(1).contains("Autogenerated by Thrift Compiler") || lines.get(0).startsWith("// $ANTLR") || lines.get(0).startsWith("//$ANTLR") || (lines.get(0).contains("generated by") || lines.get(0).contains("Generated by")) && lines.get(0).contains("ANTLR"));
    }

    public String getProjectRelativePath(String path) {
        String projectPath = new File(this.config.projectPath).getAbsolutePath();
        File pathFile = new File(path = StringUtils.strip((String)path, (String)" \""));
        if (!pathFile.isAbsolute()) {
            path = new File(projectPath, path).getAbsolutePath();
        }
        return this.makeRelativePath(path, projectPath, ".", true);
    }

    private boolean isRelative(String path, String root, boolean calcAbsolutePaths) {
        if (!calcAbsolutePaths) {
            path = path.replace('\\', '/');
            root = root.replace('\\', '/');
        }
        return !this.makeRelativePath(path, root, calcAbsolutePaths).equals(path);
    }

    @NotNull
    public String makeRelativePath(String path, String root, boolean calcAbsolutePaths) {
        return this.makeRelativePath(path, root, ".", calcAbsolutePaths);
    }

    @NotNull
    public String makeRelativePath(String path, String root, String relativeMark, boolean calcAbsolutePaths) {
        if (root.isEmpty()) {
            return path;
        }
        PathResolver pathResolver = PathResolver.forConfig(this.config);
        if (calcAbsolutePaths) {
            path = pathResolver.resolveAbsolutePath(path);
            root = pathResolver.resolveAbsolutePath(root);
        }
        if (path.equals(root)) {
            return relativeMark;
        }
        if (path.startsWith(root + '/')) {
            return relativeMark + '/' + path.substring(root.length() + 1);
        }
        return path;
    }
}

