/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pvsstudio.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class ConfigReader<T> {
    private static final Gson DEFAULT_GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    @NotNull
    private final Path path;
    @NotNull
    private final Class<T> configClass;

    public ConfigReader(@NotNull Path path, @NotNull Class<T> configClass) {
        this.path = path;
        this.configClass = configClass;
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public void write(T value) throws IOException {
        Utils.createDirectoriesToFile(this.path.toFile());
        try (RandomAccessFile raf = new RandomAccessFile(this.path.toFile(), "rw");){
            FileChannel channel = raf.getChannel();
            FileLock ignore = channel.lock();
            try (BufferedWriter buffWriter = new BufferedWriter(new OutputStreamWriter(Channels.newOutputStream(channel), StandardCharsets.UTF_8));){
                channel.truncate(0L);
                DEFAULT_GSON.toJson(value, (Appendable)buffWriter);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public T read() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class InvalidFormatException
    extends IOException {
        public InvalidFormatException(String message) {
            super(message);
        }
    }
}

