/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsOSUtils;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.WarningGroup;
import com.pvsstudio.WarningInfo;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Utils {
    public static final String LICENSE_NOT_ENTERED_MESSAGE = "License was not entered.";
    public static final String PLEASE_ENTER_VALID_LICENSE = "Please enter a valid PVS-Studio license or request a trial license at https://pvs-studio.com/en/pvs-studio/try-free/.";
    public static final String JAVA_ACTIVATE_LICENSE_COMMAND_EXAMPLE = "Command example: java -jar pvs-studio.jar --activate-license --user-name \"PVS-Studio Free\" --license-key FREE-FREE-FREE-FREE.";
    public static final String PATH_TO_LICENSE_DIRECTORY_WIN = "The analyzer writes the license to the settings file located in the default directory: %APPDATA%/PVS-Studio/Settings.xml.";
    public static final String PATH_TO_LICENSE_DIRECTORY_UNIX_MAC = "The analyzer writes the license to the license file located in the default directory: ~/.config/PVS-Studio/PVS-Studio.lic.";
    private static final Map<File, Set<File>> cache = new HashMap<File, Set<File>>();

    private Utils() {
        throw new IllegalStateException("utility class");
    }

    @Deprecated
    @NotNull
    public static String absolutePath(@NotNull String path) {
        if (path.equals("~")) {
            path = System.getProperty("user.home");
        } else if (path.startsWith("~\\") || path.startsWith("~/")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (IOException ignored) {
            path = new File(path).getAbsolutePath();
        }
        return Utils.normalizePath(path);
    }

    @NotNull
    public static String absolutePath(@NotNull String path, String ... tail) {
        return Utils.absolutePath(Utils.joinPath(path, tail));
    }

    @NotNull
    public static File absolutePath(@NotNull File path) {
        return new File(Utils.absolutePath(path.getAbsolutePath()));
    }

    @Deprecated
    @NotNull
    public static String normalizePath(@NotNull String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replace("\\", "/");
    }

    public static boolean isAbsolutePath(@NotNull String path) {
        return path.equals("~") || path.startsWith("~/") || path.startsWith("~\\") || new File(path).isAbsolute();
    }

    @NotNull
    public static String joinPath(@NotNull String path, String ... tail) {
        String res = path;
        for (String s : tail) {
            res = res.isEmpty() ? s : (Utils.isAbsolutePath(s) ? Utils.normalizePath(s) : Utils.normalizePath(res) + '/' + s);
        }
        return res;
    }

    @NotNull
    public static String makeRelativePath(@NotNull String path, @NotNull String root, @NotNull String relativeMark, boolean calcAbsolutePaths) {
        if (root.isEmpty()) {
            return path;
        }
        if (calcAbsolutePaths) {
            path = Utils.absolutePath(path);
            root = Utils.absolutePath(root);
        }
        if (path.equals(root)) {
            return relativeMark;
        }
        if (path.startsWith(root + '/')) {
            return relativeMark + '/' + path.substring(root.length() + 1);
        }
        return path;
    }

    @NotNull
    public static String makeRelativePath(@NotNull String path, @NotNull String root, @NotNull String relativeMark) {
        return Utils.makeRelativePath(path, root, relativeMark, true);
    }

    @NotNull
    public static String makeRelativePath(@NotNull String path, @NotNull String root) {
        return Utils.makeRelativePath(path, root, ".");
    }

    @NotNull
    public static List<String> splitWords(@NotNull String str) {
        String camelcaseOrSnakecaseRegularExpression = "(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])|_";
        return Arrays.stream(str.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])|_")).filter(word -> !word.isEmpty()).collect(Collectors.toList());
    }

    public static boolean isRuleEnabled(@NotNull AnalyzerConfig config, @NotNull String rule) {
        if (config.enableAllWarnings.booleanValue() || config.additionalWarnings.contains(rule)) {
            return true;
        }
        if (!config.enabledWarnings.isEmpty() && !config.enabledWarnings.contains(rule) || config.disabledWarnings.contains(rule)) {
            return false;
        }
        if (!config.enabledWarnings.isEmpty()) {
            return true;
        }
        WarningGroup group = WarningGroup.byName(rule);
        if (!config.analysisMode.contains((Object)group)) {
            return false;
        }
        WarningInfo info = WarningInfo.WARNINGS.get(rule);
        return info == null || !info.isDisabledByDefault();
    }

    public static <T> void bubbleSort(@NotNull List<T> list, @NotNull Comparator<T> comparator) {
        for (int i = 0; i < list.size() - 1; ++i) {
            T left = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                T right = list.get(j);
                if (comparator.compare(left, right) <= 0) continue;
                list.set(i, right);
                list.set(j, left);
                left = right;
            }
        }
    }

    @NotNull
    public static String getFileExtensionWithoutPoint(@NotNull File file) {
        String name = file.getName();
        int lastIndex = name.lastIndexOf(46);
        return lastIndex == -1 || lastIndex == name.length() - 1 ? "" : name.substring(lastIndex + 1);
    }

    @NotNull
    public static String getLicenseInfoFromSettingsXml(@NotNull String settingsPath) throws ParserConfigurationException, IOException, SAXException {
        String serialNumber;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        Document doc = factory.newDocumentBuilder().parse(new File(settingsPath));
        doc.getDocumentElement().normalize();
        String userName = Utils.getNodeValueByTagName(doc, "UserName");
        if (userName == null) {
            userName = "";
        }
        if ((serialNumber = Utils.getNodeValueByTagName(doc, "SerialNumber")) == null) {
            serialNumber = "";
        }
        return userName + System.lineSeparator() + serialNumber;
    }

    public static boolean allCredentialsPresent(@NotNull AnalyzerConfig config, @Nullable Consumer<String> output) {
        boolean anyEmpty;
        String message = null;
        String messageEnding = "Please enter a valid PVS-Studio license or request a trial license at https://pvs-studio.com/en/pvs-studio/try-free/. Command example: java -jar pvs-studio.jar --activate-license --user-name \"PVS-Studio Free\" --license-key FREE-FREE-FREE-FREE.";
        if (StringUtils.isEmpty((CharSequence)config.getUserName())) {
            message = "Empty username.";
        }
        if (StringUtils.isEmpty((CharSequence)config.getLicenseKey())) {
            message = "Empty serial number.";
        }
        if (StringUtils.isEmpty((CharSequence)config.getUserName()) && StringUtils.isEmpty((CharSequence)config.getLicenseKey())) {
            message = LICENSE_NOT_ENTERED_MESSAGE;
        }
        boolean bl = anyEmpty = message != null;
        if (anyEmpty && output != null) {
            if (PvsOSUtils.isWindows()) {
                output.accept(message + " " + "Please enter a valid PVS-Studio license or request a trial license at https://pvs-studio.com/en/pvs-studio/try-free/. Command example: java -jar pvs-studio.jar --activate-license --user-name \"PVS-Studio Free\" --license-key FREE-FREE-FREE-FREE." + " " + PATH_TO_LICENSE_DIRECTORY_WIN);
            } else {
                output.accept(message + " " + "Please enter a valid PVS-Studio license or request a trial license at https://pvs-studio.com/en/pvs-studio/try-free/. Command example: java -jar pvs-studio.jar --activate-license --user-name \"PVS-Studio Free\" --license-key FREE-FREE-FREE-FREE." + " " + PATH_TO_LICENSE_DIRECTORY_UNIX_MAC);
            }
        }
        return !anyEmpty;
    }

    @Nullable
    public static String getNodeValueByTagName(@NotNull Document doc, @NotNull String tagName) {
        Node node;
        String nodeValue = null;
        NodeList nodeList = doc.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1 && node.hasChildNodes()) {
            nodeValue = node.getFirstChild().getNodeValue();
        }
        return nodeValue;
    }

    public static int getRecommendedThreadsCount() {
        try {
            long memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
            long logicalCores = Runtime.getRuntime().availableProcessors();
            return (int)Math.max(1L, Math.min(logicalCores, (memorySize /= 0x40000000L) / 2L));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Runtime.getRuntime().availableProcessors();
        }
    }

    public static void createDirectoriesToFile(@NotNull File file) throws PvsStudioException {
        File fileDirectory = file.getParentFile();
        if (fileDirectory != null && !fileDirectory.exists() && !fileDirectory.mkdirs()) {
            throw new PvsStudioException("Directory " + fileDirectory + " does not exist and could not be created");
        }
    }

    @NotNull
    public static Set<File> collectAllClasspathFiles(@Nullable Set<String> classpathStrings) {
        Set<File> classPathResources = Optional.ofNullable(classpathStrings).orElse(Collections.emptySet()).stream().map(File::new).collect(Collectors.toSet());
        return Utils.getAllClasspathFiles(classPathResources);
    }

    @NotNull
    public static Set<File> collectAllJavaFiles(@Nullable Set<String> sourceFilesPaths) {
        Set<File> sourceFiles = Optional.ofNullable(sourceFilesPaths).orElse(Collections.emptySet()).stream().map(File::new).collect(Collectors.toSet());
        return Utils.getAllJavaFiles(sourceFiles).stream().filter(f -> !f.getName().equals("package-info.java") && !f.getName().equals("module-info.java")).collect(Collectors.toSet());
    }

    @NotNull
    private static Set<File> getAllJavaFiles(@NotNull Set<File> resources) {
        return Utils.getAllFilesByExtension(resources, false, ".java");
    }

    @NotNull
    private static Set<File> getAllClasspathFiles(@NotNull Set<File> resources) {
        return Utils.getAllFilesByExtension(resources, true, ".jar");
    }

    @NotNull
    private static Set<File> getAllFilesByExtension(@NotNull Set<File> resources, boolean isIncludeDirs, String ... ext) {
        HashSet<File> allFiles = new HashSet<File>();
        for (File resource : resources) {
            allFiles.addAll(cache.computeIfAbsent(resource, file -> {
                try {
                    HashSet<File> files = new HashSet<File>();
                    if (file.isDirectory()) {
                        Collection filesDir = FileUtils.listFiles((File)file, (IOFileFilter)new SuffixFileFilter(ext), (IOFileFilter)TrueFileFilter.INSTANCE);
                        filesDir.forEach(f -> {
                            try {
                                files.add(f.getCanonicalFile());
                            }
                            catch (IOException e) {
                                throw new PvsStudioException("unable to locate file: " + f, e);
                            }
                        });
                        if (isIncludeDirs) {
                            files.add(file.getCanonicalFile());
                        }
                    } else if (file.isFile() && Arrays.stream(ext).anyMatch(s -> file.getName().endsWith((String)s))) {
                        files.add(file.getCanonicalFile());
                    }
                    return files;
                }
                catch (IOException e) {
                    throw new PvsStudioException("unable to locate file: " + file, e);
                }
            }));
        }
        return allFiles;
    }
}

