/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.JsonProject;
import com.pvsstudio.MavenGradlePluginTask;
import com.pvsstudio.PvsJavaPluginConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.PvsStudioInvoker;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PvsMavenMojo
extends AbstractMojo
implements MavenGradlePluginTask {
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject currentProject;

    @Override
    @NotNull
    public String projectRootFolder() {
        return this.currentProject.getBasedir().getAbsolutePath();
    }

    @Override
    @NotNull
    public PvsJavaPluginConfig.Plugin pluginType() {
        return PvsJavaPluginConfig.Plugin.MAVEN;
    }

    @Nullable
    public MojoFailureException taskException(@Nullable PvsStudioException pvsStudioException) {
        if (pvsStudioException == null) {
            return null;
        }
        return new MojoFailureException(this.taskFailedMessage(), (Throwable)pvsStudioException);
    }

    public final void executeTask() throws MojoFailureException {
        MojoFailureException taskException;
        try {
            this.initJavaAnalyzerCore();
            JsonProject jsonProject = this.jsonProject();
            PvsJavaPluginConfig pluginConfig = this.pvsJavaPluginConfig(this.projectFolderAbsolutePath(), this.pluginType(), this.configFromProperties(), this.configFromBuildSystemScript(), this.globalConfig());
            taskException = this.executeTaskAndGetException(pluginConfig, jsonProject);
        }
        catch (Throwable throwable) {
            taskException = new MojoFailureException(this.taskFailedMessage(), throwable);
        }
        if (taskException != null) {
            this.printExampleMessageAndThrowMojoFailureException(taskException);
        }
    }

    @Nullable
    public MojoFailureException executeTaskAndGetException(@NotNull PvsJavaPluginConfig pluginConfig, @NotNull JsonProject jsonProject) {
        int javaCoreReturnCode = PvsStudioInvoker.runAnalyzerCoreProcess(System.out::println, pluginConfig, jsonProject);
        MojoFailureException taskException = javaCoreReturnCode != 0 ? this.taskException(this.pvsStudioExceptionForRunAnalyzerProcessFromMavenOrGradlePlugins(javaCoreReturnCode, pluginConfig)) : null;
        return taskException;
    }

    protected void printExampleMessageAndThrowMojoFailureException(@NotNull MojoFailureException mojoFailureException) throws MojoFailureException {
        this.printExampleMessage();
        throw mojoFailureException;
    }
}

