/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioException;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

public class PvsJavaPluginConfig
extends AnalyzerConfig {
    private PvsJavaPluginConfig(@NotNull AnalyzerConfig other) {
        this.fillNonStaticFieldsFrom(other);
    }

    public PvsJavaPluginConfig(@NotNull AnalyzerConfig other, @NotNull Plugin plugin, @NotNull String projectPath) {
        this.fillNonStaticFieldsFrom(other);
        switch (plugin) {
            case GRADLE: {
                this.launchMode = AnalyzerConfig.LaunchMode.GRADLE;
                break;
            }
            case MAVEN: {
                this.launchMode = AnalyzerConfig.LaunchMode.MAVEN;
                break;
            }
            case IDEA: {
                this.launchMode = AnalyzerConfig.LaunchMode.IDEA;
            }
        }
        this.projectPath = projectPath;
    }

    @Override
    @NotNull
    public PvsJavaPluginConfig normalize() throws PvsStudioException {
        return (PvsJavaPluginConfig)super.normalize();
    }

    @Override
    @NotNull
    public PvsJavaPluginConfig normalizeAndReadLicenseFile() throws PvsStudioException, IOException, ParserConfigurationException, SAXException {
        return (PvsJavaPluginConfig)super.normalizeAndReadLicenseFile();
    }

    @Override
    @NotNull
    protected File getJavaCoreExecutableJar() throws PvsStudioException {
        File pvsStudioJar = new File(AnalyzerConfig.PVS_JAVA_ANALYZER_CORE_EXECUTABLE);
        if (!pvsStudioJar.exists()) {
            throw new PvsStudioException(pvsStudioJar.getAbsolutePath() + " doesn't exist");
        }
        return pvsStudioJar;
    }

    @Override
    @NotNull
    public PvsJavaPluginConfig copy() {
        return new PvsJavaPluginConfig(this);
    }

    public static enum Plugin {
        GRADLE,
        MAVEN,
        IDEA;

    }
}

