/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.JsonModule;
import com.pvsstudio.JsonProject;
import com.pvsstudio.MavenGradlePluginAnalyzeTaskConverter;
import com.pvsstudio.MavenTaskParametersProvider;
import com.pvsstudio.PvsMavenMojo;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.Utils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.annotations.NotNull;

@Mojo(name="pvsAnalyze", aggregator=true, inheritByDefault=false, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.TEST)
public class PvsAnalyzeMojo
extends PvsMavenMojo {
    public static final String TASK_NAME = "pvsAnalyze";
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter
    private final AnalyzerConfig analyzer = AnalyzerConfig.blankConfig();

    private void addStringPath(MavenProject project, String path, Set<String> sources) {
        File pathFile = new File(path);
        if (pathFile.isAbsolute()) {
            sources.add(path);
        } else {
            pathFile = new File(project.getBasedir(), path);
            sources.add(Utils.absolutePath(pathFile.getAbsolutePath()));
        }
    }

    private void addSourcesFromExecution(MavenProject project, PluginExecution execution, Set<String> sources) {
        Xpp3Dom configurationDom;
        Xpp3Dom sourcesDom;
        Object configuration;
        if (execution != null && (configuration = execution.getConfiguration()) instanceof Xpp3Dom && (sourcesDom = (configurationDom = (Xpp3Dom)configuration).getChild("sources")) != null) {
            for (Xpp3Dom sourceDom : sourcesDom.getChildren()) {
                String path = sourceDom.getValue();
                this.addStringPath(project, path, sources);
            }
        }
    }

    private void addSourcesFromBuildHelperPlugin(MavenProject project, Set<String> mainSources, Set<String> testSources) {
        Plugin helperPlugin = (Plugin)project.getBuild().getPluginsAsMap().get("org.codehaus.mojo:build-helper-maven-plugin");
        if (helperPlugin == null) {
            return;
        }
        for (PluginExecution execution : helperPlugin.getExecutions()) {
            if (execution.getGoals().contains("add-source")) {
                this.addSourcesFromExecution(project, execution, mainSources);
            }
            if (!execution.getGoals().contains("add-test-source")) continue;
            this.addSourcesFromExecution(project, execution, testSources);
        }
    }

    private void addSourcesFromDefaultGeneratedDirs(MavenProject project, Set<String> mainSources, Set<String> testSources) {
        File generatedTestSourcesDir;
        File generatedSourcesDir = new File(project.getBuild().getDirectory(), "generated-sources");
        if (generatedSourcesDir.exists()) {
            mainSources.add(generatedSourcesDir.getPath());
        }
        if ((generatedTestSourcesDir = new File(project.getBuild().getDirectory(), "generated-test-sources")).exists()) {
            testSources.add(generatedTestSourcesDir.getPath());
        }
    }

    private Set<String> getSourcesFromPvsStudioAdditionalProperty(MavenProject project) {
        HashSet<String> sources = new HashSet<String>();
        String additionalSources = project.getProperties().getProperty("pvsStudioAdditionalSources");
        if (additionalSources != null) {
            String[] elements;
            for (String e : elements = additionalSources.split(",")) {
                String path = e.trim();
                this.addStringPath(project, path, sources);
            }
        }
        return sources;
    }

    @Override
    @NotNull
    public JsonProject jsonProject() {
        JsonProject jsonProject = new JsonProject();
        for (MavenProject p : this.reactorProjects) {
            try {
                String dir = p.getBasedir().getPath();
                HashSet<String> mainSources = new HashSet<String>();
                mainSources.addAll(p.getCompileSourceRoots());
                mainSources.addAll(this.getSourcesFromPvsStudioAdditionalProperty(p));
                HashSet<String> testSources = new HashSet<String>(p.getTestCompileSourceRoots());
                this.addSourcesFromBuildHelperPlugin(p, mainSources, testSources);
                this.addSourcesFromDefaultGeneratedDirs(p, mainSources, testSources);
                HashSet<String> fullSources = new HashSet<String>();
                fullSources.addAll(mainSources);
                fullSources.addAll(testSources);
                HashSet<String> classpath = new HashSet<String>();
                classpath.addAll(p.getCompileClasspathElements());
                classpath.addAll(p.getTestClasspathElements());
                classpath.remove(p.getBuild().getOutputDirectory());
                classpath.remove(p.getBuild().getTestOutputDirectory());
                Path buildDir = Paths.get(p.getBuild().getDirectory(), new String[0]);
                Set<String> generatedSources = fullSources.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(it -> it.startsWith(buildDir)).map(Path::toString).collect(Collectors.toSet());
                jsonProject.modules.add(new JsonModule(p.getArtifactId(), dir, fullSources, testSources, classpath, generatedSources));
            }
            catch (DependencyResolutionRequiredException e) {
                throw new PvsStudioException("Error when retrieving information about projects", e);
            }
        }
        return jsonProject;
    }

    @Override
    @NotNull
    public MavenGradlePluginAnalyzeTaskConverter taskParameterConverter() {
        return new MavenGradlePluginAnalyzeTaskConverter(new MavenTaskParametersProvider(this.session.getRequest().getUserProperties()));
    }

    @Override
    @NotNull
    public AnalyzerConfig configFromBuildSystemScript() {
        return this.analyzer;
    }

    @Override
    @NotNull
    public String taskName() {
        return TASK_NAME;
    }

    public void execute() throws MojoFailureException {
        if (!this.currentProject.isExecutionRoot()) {
            return;
        }
        this.executeTask();
    }
}

