/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.JsonProject;
import com.pvsstudio.MavenGradlePluginTask;
import com.pvsstudio.PvsJavaPluginConfig;
import com.pvsstudio.PvsStudioConfigException;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.PvsStudioInvoker;
import com.pvsstudio.TaskParameterConverter;
import com.pvsstudio.TaskParametersProvider;
import com.pvsstudio.Utils;
import com.pvsstudio.util.license.LicenseWriter;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface MavenGradlePluginCredentialTask
extends MavenGradlePluginTask {
    public static final String username_TASK_PARAMETER_NAME = "username";
    public static final String SERIAL_TASK_PARAMETER_NAME = "serialNumber";
    public static final String userName_TASK_PARAMETER_NAME = "userName";
    public static final String LICENSE_KEY_TASK_PARAMETER_NAME = "licenseKey";
    public static final String[] taskParametersNames = new String[]{"username", "userName", "serialNumber", "licenseKey"};

    public static void checkAnalyzerConfigContainsFieldsWithNames() {
        for (String fieldName : taskParametersNames) {
            if (TaskParameterConverter.analyzerConfigNonStaticFieldsNames.contains(fieldName)) continue;
            throw new PvsStudioException("Class AnalyzerConfig does not contain a field named " + fieldName);
        }
    }

    @Override
    @NotNull
    default public String commandExampleMessage() {
        String pluginTaskParameterStartFlag = this.pluginTaskParameterStartFlag();
        String doubleQuotes = "\"";
        return "Invalid command format. Usage: " + this.taskName() + " " + "\"" + pluginTaskParameterStartFlag + TaskParameterConverter.addPrefix(userName_TASK_PARAMETER_NAME) + "=USERNAME" + "\"" + " " + "\"" + pluginTaskParameterStartFlag + TaskParameterConverter.addPrefix(LICENSE_KEY_TASK_PARAMETER_NAME) + "=KEY" + "\"";
    }

    @Override
    default public Exception executeTaskAndGetException(@NotNull PvsJavaPluginConfig pluginConfig, @NotNull JsonProject jsonProject) {
        String incorrectRegistrationInfoMessage = "Incorrect registration info.";
        PvsStudioException pvsStudioException = null;
        if (!Utils.allCredentialsPresent(pluginConfig, System.out::println)) {
            return this.taskException(new PvsStudioException("Either username or serial number is empty"));
        }
        try {
            PvsStudioInvoker.CheckLicenseInfoFromSeparateProcess checkLicenseInfo = PvsStudioInvoker.checkLicenseFromPvsStudioJar(pluginConfig);
            if (checkLicenseInfo.exitCode == 0) {
                if (checkLicenseInfo.valid) {
                    if (checkLicenseInfo.isTimedOut) {
                        System.out.println("Your license is expired");
                    } else {
                        System.out.println("Valid " + checkLicenseInfo.licenseType);
                        if (checkLicenseInfo.daysLeft < 31L) {
                            System.out.printf("Your license will expire in %s days%n", checkLicenseInfo.daysLeft);
                        }
                    }
                } else {
                    System.out.println("Incorrect registration info.");
                    pvsStudioException = new PvsStudioException("Incorrect registration info.");
                }
            } else {
                for (String processStdoutLine : checkLicenseInfo.processStdoutLines) {
                    System.out.println(processStdoutLine);
                }
                pvsStudioException = this.pvsStudioExceptionForRunAnalyzerProcessFromMavenOrGradlePlugins(checkLicenseInfo.exitCode, pluginConfig);
            }
            if (pvsStudioException == null) {
                LicenseWriter licenseWriter = LicenseWriter.forConfig(pluginConfig);
                licenseWriter.write(pluginConfig.getUserName(), pluginConfig.getLicenseKey());
            }
        }
        catch (PvsStudioConfigException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("Incorrect registration info.");
            pvsStudioException = new PvsStudioException("Incorrect registration info.", e);
        }
        return this.taskException(pvsStudioException);
    }

    public static class CredentialTaskParameterConverter
    extends TaskParameterConverter {
        public CredentialTaskParameterConverter(@NotNull TaskParametersProvider taskParametersProvider) {
            super(taskParametersProvider);
        }

        @Override
        @NotNull
        protected Set<String> getTaskParametersNames() {
            return this.addPrefixToTaskParametersNames(Arrays.stream(taskParametersNames));
        }

        @Override
        @NotNull
        protected Class<?> getParameterValueType(@NotNull String taskParameterName) {
            return taskParameterName.getClass();
        }
    }
}

