/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlOutput
implements WarningsOutput {
    @Override
    @NotNull
    public String[] names() {
        return new String[]{"xml"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"xml"};
    }

    private String escapeHtml(String src) {
        return src.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    @Override
    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings, @NotNull BufferedWriter writer) throws IOException {
        writer.write(String.format("%s%n%s%n", "<?xml version=\"1.0\"?>", "<NewDataSet>"));
        for (Warning w : warnings) {
            Optional<String> addLines;
            if (w.falseAlarm) continue;
            String file = "";
            int line = 0;
            if (!w.positions.isEmpty()) {
                file = w.positions.get((int)0).file;
                line = w.positions.get((int)0).line;
            }
            StringBuilder formatString = new StringBuilder(String.format("  <PVS-Studio_Analysis_Log>%n    <Level>%d</Level>%n    <ErrorCode>%s</ErrorCode>%n    <Message>%s</Message>%n    <Line>%d</Line>%n    <File>%s</File>%n", w.level.ordinal(), w.code, this.escapeHtml(w.message), line, file));
            if (w.cwe != 0) {
                formatString.append(String.format("    <CWECode>CWE-%d</CWECode>%n", w.cwe));
            }
            if ((addLines = w.getAdditionalLinesString()).isPresent() && addLines.get().chars().noneMatch(Character::isLetter)) {
                formatString.append(String.format("    <LineExtension>%s</LineExtension>%n", addLines.get().replaceAll(" ", "")));
            }
            formatString.append("  </PVS-Studio_Analysis_Log>\n");
            writer.write(formatString.toString());
        }
        writer.write(String.format("%s%n", "</NewDataSet>"));
    }
}

