/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.Utils;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarningsSet
implements Collection<Warning> {
    private static final Comparator<Warning> DEFAULT_ORDER = Comparator.comparing(warning -> warning.level).thenComparing(warning -> warning.code).thenComparing(warning -> warning.sastId != null ? warning.sastId : "").thenComparing(warning -> warning.message).thenComparing(warning -> warning.positions.size()).thenComparing(warning -> Warning.getPositionsString(warning.positions));
    private final Set<Warning> uniqueWarnings = new HashSet<Warning>();
    @Nullable
    private final Consumer<Warning> printAsRawJsonOnWarningAdded;

    public WarningsSet(@NotNull Consumer<Warning> printAsRawJsonOnWarningAdded) {
        this.printAsRawJsonOnWarningAdded = printAsRawJsonOnWarningAdded;
    }

    private WarningsSet() {
        this.printAsRawJsonOnWarningAdded = null;
    }

    @NotNull
    public static WarningsSet createNew() {
        return new WarningsSet();
    }

    @Override
    public boolean add(Warning warning) {
        boolean result = this.uniqueWarnings.add(warning);
        if (result && this.printAsRawJsonOnWarningAdded != null) {
            this.printAsRawJsonOnWarningAdded.accept(warning);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        return this.uniqueWarnings.remove(o);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Warning> warnings) {
        boolean added = false;
        for (Warning warning : warnings) {
            if (!this.add(warning)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean isEmpty() {
        return this.uniqueWarnings.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Warning> iterator() {
        return this.uniqueWarnings.stream().sorted(DEFAULT_ORDER).iterator();
    }

    @Override
    @NotNull
    public Stream<Warning> stream() {
        return this.uniqueWarnings.stream().sorted(DEFAULT_ORDER);
    }

    public String toString() {
        return this.uniqueWarnings.toString();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.uniqueWarnings.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.uniqueWarnings.toArray(a);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.removeIf((Predicate<? super Warning>)((Predicate<Warning>)c::contains));
    }

    @Override
    public boolean removeIf(Predicate<? super Warning> filter) {
        List toRemove = this.uniqueWarnings.stream().filter(filter).collect(Collectors.toList());
        boolean removed = false;
        for (Warning warning : toRemove) {
            if (!this.remove(warning)) continue;
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.removeIf((Predicate<? super Warning>)((Predicate<Warning>)w -> !c.contains(w)));
    }

    @Override
    public void clear() {
        this.uniqueWarnings.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.uniqueWarnings.contains(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.uniqueWarnings.containsAll(c);
    }

    @Override
    public int size() {
        return this.uniqueWarnings.size();
    }

    public boolean hasAnyFail() {
        return this.uniqueWarnings.stream().anyMatch(w -> w.level == WarningLevel.LEVEL_0);
    }

    private void replacePrefix(@NotNull String from, @NotNull String to) {
        from = Utils.normalizePath((String)from) + "/";
        to = Utils.normalizePath((String)to) + "/";
        for (Warning warning : this.uniqueWarnings) {
            for (int i = 0; i < warning.positions.size(); ++i) {
                String normalPositionFile;
                WarningPosition position = warning.positions.get(i);
                if (position.file == null || !(normalPositionFile = Utils.normalizePath(position.file)).startsWith((String)from)) continue;
                WarningPosition newPos = new WarningPosition((String)to + normalPositionFile.substring(((String)from).length()), position.line, position.endLine, position.column, position.endColumn, new NavigationInfo(position.navigation));
                warning.positions.set(i, newPos);
            }
        }
    }

    public void makeRelativePaths(@NotNull String root) {
        this.replacePrefix(root, "|?|");
    }

    public void makeAbsolutePaths(@NotNull String root) {
        this.replacePrefix("|?|", root);
    }
}

