/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.PvsStudioException;
import com.pvsstudio.warnings.WarningsFormat;
import com.pvsstudio.warnings.WarningsOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class WarningsFormatFactory {
    private static List<WarningsFormat> formats = null;

    private WarningsFormatFactory() {
    }

    public static List<WarningsFormat> getFormats() {
        if (formats == null) {
            formats = new ArrayList<WarningsFormat>();
            ArrayList<String> packageNames = new ArrayList<String>();
            packageNames.add(WarningsFormatFactory.class.getPackage().getName());
            packageNames.add("com.pvsstudio.formats");
            HashSet outputFormats = new HashSet();
            for (String packageName : packageNames) {
                Reflections reflections = new Reflections(packageName, new Scanner[0]);
                outputFormats.addAll(reflections.getSubTypesOf(WarningsOutput.class));
            }
            for (Class format : outputFormats) {
                try {
                    formats.add((WarningsFormat)format.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new PvsStudioException("failed to instantiate formats", e);
                }
            }
        }
        return formats;
    }

    @NotNull
    public static <T extends WarningsFormat> T getFormatByName(@NotNull String name, @NotNull Class<T> type) {
        return (T)WarningsFormatFactory.getFormats().stream().filter(f -> ArrayUtils.contains((Object[])f.names(), (Object)name)).filter(type::isInstance).map(type::cast).findFirst().orElseThrow(() -> new PvsStudioException("Unknown format: " + name));
    }

    @NotNull
    public static <T extends WarningsFormat> T getFormatByExtension(@NotNull String extension, @NotNull Class<T> type) {
        return (T)WarningsFormatFactory.getFormats().stream().filter(f -> ArrayUtils.contains((Object[])f.extensions(), (Object)extension)).filter(type::isInstance).map(type::cast).findFirst().orElseThrow(() -> new PvsStudioException("Unknown format: " + extension));
    }
}

