/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningPosition;
import com.pvsstudio.warnings.WarningsSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;

public class WarningsDuplicates {
    private final List<BiPredicate<Warning, Warning>> filters = new ArrayList<BiPredicate<Warning, Warning>>();

    private static boolean filterPosition(Warning warning1, Warning warning2, boolean byLine, List<String> names) {
        if (warning1.positions.isEmpty() || warning2.positions.isEmpty()) {
            return false;
        }
        int p1 = names.indexOf(warning1.code);
        int p2 = names.indexOf(warning2.code);
        if (p1 == -1 || p2 == -1 || p1 >= p2) {
            return false;
        }
        if (byLine) {
            WarningPosition pos1 = warning1.positions.get(0);
            WarningPosition pos2 = warning2.positions.get(0);
            return pos1.file != null && pos1.file.equals(pos2.file) && pos1.line == pos2.line;
        }
        for (int i = 0; i < warning1.positions.size(); ++i) {
            for (int j = 0; j < warning2.positions.size(); ++j) {
                WarningPosition pos1 = warning1.positions.get(i);
                WarningPosition pos2 = warning2.positions.get(j);
                if (pos1.file == null || !pos1.equals(pos2)) continue;
                return true;
            }
        }
        return false;
    }

    public WarningsDuplicates byLine(String ... names) {
        this.filters.add((warning1, warning2) -> WarningsDuplicates.filterPosition(warning1, warning2, true, Arrays.asList(names)));
        return this;
    }

    public WarningsDuplicates byPosition(String ... names) {
        this.filters.add((warning1, warning2) -> WarningsDuplicates.filterPosition(warning1, warning2, false, Arrays.asList(names)));
        return this;
    }

    public WarningsDuplicates add(@NotNull BiPredicate<Warning, Warning> filter) {
        this.filters.add(filter);
        return this;
    }

    public void removeFrom(@NotNull WarningsSet warnings) {
        ArrayList removed = new ArrayList();
        for (Warning warning : warnings) {
            if (warning.positions.isEmpty()) continue;
            warnings.stream().filter(warning2 -> warning != warning2).filter(warning2 -> !warning2.positions.isEmpty()).filter(warning2 -> this.filters.stream().anyMatch(conflict -> conflict.test(warning, warning2))).forEach(removed::add);
        }
        warnings.removeAll(removed);
    }
}

