/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.PvsStudioException;
import com.pvsstudio.warnings.NavigationInfo;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarningPosition {
    public static final String SOURCE_TREE_ROOT_MARK = "|?|";
    @Nullable
    public final String file;
    public final int line;
    public final int endLine;
    public final int column;
    public final int endColumn;
    public static final WarningPosition DEFAULT = new WarningPosition(null, 1, 1, 1, 1, null);
    public static final WarningPosition INVALID_POSITION = new WarningPosition();
    @Nullable
    public final NavigationInfo navigation;

    private WarningPosition() {
        this.file = null;
        this.line = -1;
        this.endLine = -1;
        this.column = -1;
        this.endColumn = -1;
        this.navigation = null;
    }

    public WarningPosition(@Nullable String f, int line, int endLine, int column, int endColumn, @Nullable NavigationInfo navigation) {
        this.file = StringUtils.trim((String)f);
        this.line = line;
        this.endLine = endLine;
        this.column = column;
        this.endColumn = endColumn;
        this.navigation = navigation;
        if (this.line <= 0 || this.endLine < this.line || this.column <= 0 || this.endColumn <= 0 || this.line == this.endLine && this.column > this.endColumn) {
            throw new PvsStudioException("Invalid source file position");
        }
    }

    public String toString() {
        if (this.file == null) {
            return "(unknown file)";
        }
        return this.file + ":" + this.line;
    }

    public int hashCode() {
        return (this.column | this.endColumn * 10 | this.line * 100 | this.endLine * 1000) ^ (this.file == null ? 0 : this.file.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WarningPosition)) {
            return false;
        }
        WarningPosition w2 = (WarningPosition)o;
        return Objects.equals(this.file, w2.file) && this.line == w2.line && this.endLine == w2.endLine && this.column == w2.column && this.endColumn == w2.endColumn;
    }

    public boolean isOnSameLine(@NotNull WarningPosition other) {
        boolean onSameLine;
        boolean bl = onSameLine = this.line == other.line && this.endLine == other.endLine;
        if (this.file == null && other.file == null) {
            return onSameLine;
        }
        return this.file != null && this.file.equals(other.file) && onSameLine;
    }
}

