/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.PvsStudioException;

public enum WarningLevel {
    LEVEL_0,
    LEVEL_1,
    LEVEL_2,
    LEVEL_3;


    public boolean isHigherThan(WarningLevel level) {
        switch (this.ordinal()) {
            case 0: {
                return level != LEVEL_0;
            }
            case 1: {
                return level == LEVEL_2 || level == LEVEL_3;
            }
            case 2: {
                return level == LEVEL_3;
            }
        }
        return false;
    }

    public boolean isLowerThan(WarningLevel level) {
        return level.isHigherThan(this);
    }

    public WarningLevel decrease() {
        switch (this.ordinal()) {
            case 1: {
                return LEVEL_2;
            }
            case 2: {
                return LEVEL_3;
            }
        }
        return this;
    }

    public WarningLevel increase() {
        switch (this.ordinal()) {
            case 2: {
                return LEVEL_1;
            }
            case 3: {
                return LEVEL_2;
            }
        }
        return this;
    }

    public <T> T match(T firstOrFatal, T second, T third) {
        return this.match(firstOrFatal, firstOrFatal, second, third);
    }

    public <T> T match(T fatal, T first, T second, T third) {
        switch (this.ordinal()) {
            case 0: {
                return fatal;
            }
            case 1: {
                return first;
            }
            case 2: {
                return second;
            }
            case 3: {
                return third;
            }
        }
        throw new PvsStudioException("Invalid WarningLevel");
    }
}

