/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.google.common.base.Strings;
import com.pvsstudio.PvsStudioAnalyzerFailedException;
import com.pvsstudio.PvsStudioCoreStartupException;
import com.pvsstudio.PvsStudioEmptyLicenseException;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.PvsStudioLicenseException;
import com.pvsstudio.PvsStudioTimeoutException;
import com.pvsstudio.WarningGroup;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.RawJson;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Warning {
    public static final String ERROR_INFO_FIELD_SEPARATOR = "<#~>";
    public static final char RAW_FILE_LINES_SEPARATOR = '\u0000';
    public static final String ERROR_CODE_RENEW = "Renew";
    public static final String ERROR_CODE_UPDATE = "Update";
    public static final String ERROR_CODE_TRIAL = "Trial";
    public static final String V019 = "V019";
    public static final String V061 = "V061";
    public static final String V062 = "V062";
    public static final String V063 = "V063";
    public static final String V064 = "V064";
    public static final String V065 = "V065";
    public static final List<String> JAVA_FAILS_WARNINGS_ERROR_CODES = Collections.unmodifiableList(Arrays.asList("V061", "V062", "V063", "V064", "V065"));
    public static final Warning NO_ISSUES = new Warning("", "Congratulations! PVS-Studio has not found any issues in your source code!", WarningLevel.LEVEL_1);
    public static final Warning NO_SOURCES_FOUND = new Warning("", "No sources were found.", WarningLevel.LEVEL_1);
    public static final Warning NO_SOURCES_FOUND_INCREMENTAL = new Warning("", "No changes are present for the incremental analysis.", WarningLevel.LEVEL_1);
    @NotNull
    public String code = "";
    public int cwe = 0;
    @Nullable
    public String sastId;
    @NotNull
    public WarningLevel level = WarningLevel.LEVEL_0;
    @NotNull
    public List<WarningPosition> positions = new ArrayList<WarningPosition>();
    @NotNull
    public String message = "";
    @Nullable
    public List<String> stacktrace;
    @NotNull
    public final List<String> projects = new ArrayList<String>();
    public boolean favorite = false;
    public boolean falseAlarm = false;
    @NotNull
    public List<String> analyzedSourceFiles = new ArrayList<String>();

    public static Warning noFreeLicenseMessage(@NotNull String filePath) {
        return new Warning("V009", "To use free version of PVS-Studio, source code files are required to start with a special comment.", WarningLevel.LEVEL_0, new WarningPosition(filePath, WarningPosition.DEFAULT.line, WarningPosition.DEFAULT.endLine, WarningPosition.DEFAULT.column, WarningPosition.DEFAULT.endColumn, NavigationInfo.EMPTY));
    }

    public static Warning updateMessage(@NotNull String latestVersion) {
        return new Warning(ERROR_CODE_UPDATE, String.format("A newer version of PVS-Studio is available (%s)", latestVersion), WarningLevel.LEVEL_1);
    }

    public static Warning monthExpirationMessage(long daysLeft) {
        return new Warning(ERROR_CODE_RENEW, String.format("Your license will expire in %s days. Click 'Renew' to learn more or contact us via the Feedback form on our website.", daysLeft), WarningLevel.LEVEL_1);
    }

    public static Warning modelBuildFailedMessage(@NotNull String moduleName) {
        return new Warning(V065, String.format("Unable to start the analysis on '%s' module.", moduleName), WarningLevel.LEVEL_0);
    }

    public static Warning modelBuildFailedCliMessage(@NotNull String pvsPluginName) {
        return new Warning(V065, String.format("Unable to start analysis of several modules. Try launching analysis with the %s.", pvsPluginName), WarningLevel.LEVEL_0);
    }

    public static Warning ruleExceptionWarning(Exception e, String ruleName) {
        return new Warning(V064, String.format("A code fragment cannot be analyzed with rule '%s'.", ruleName), WarningLevel.LEVEL_0).addStacktrace(e);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Warning)) {
            return false;
        }
        Warning w2 = (Warning)other;
        return this.cwe == w2.cwe && this.code.equals(w2.code) && Objects.equals(this.sastId, w2.sastId) && this.level == w2.level && this.positions.equals(w2.positions) && this.message.equals(w2.message) && Objects.equals(this.stacktrace, w2.stacktrace) && this.favorite == w2.favorite && this.falseAlarm == w2.falseAlarm;
    }

    public int hashCode() {
        return Objects.hash(this.code, this.positions.isEmpty() ? Integer.valueOf(1) : this.positions.get(0));
    }

    public Warning(@NotNull RawJson rawJson) {
        WarningGroup warningGroup;
        this.code = rawJson.code;
        this.message = rawJson.message;
        this.falseAlarm = rawJson.falseAlarm;
        this.analyzedSourceFiles = Arrays.asList(rawJson.analyzedSourceFiles);
        switch (rawJson.level) {
            case 1: {
                this.level = WarningLevel.LEVEL_1;
                break;
            }
            case 2: {
                this.level = WarningLevel.LEVEL_2;
                break;
            }
            case 3: {
                this.level = WarningLevel.LEVEL_3;
                break;
            }
            default: {
                this.level = WarningLevel.LEVEL_0;
            }
        }
        boolean codeNotNumber = this.code.equalsIgnoreCase(ERROR_CODE_RENEW) || this.code.equalsIgnoreCase(ERROR_CODE_UPDATE) || this.code.equalsIgnoreCase(ERROR_CODE_TRIAL);
        WarningGroup warningGroup2 = warningGroup = !this.code.isEmpty() && NumberUtils.isDigits((String)this.code.substring(1)) ? WarningGroup.byCode(Integer.parseInt(this.code.substring(1))) : WarningGroup.UNKNOWN;
        if (codeNotNumber || warningGroup != WarningGroup.UNKNOWN) {
            if ("V004".equals(this.code)) {
                return;
            }
            if (warningGroup != WarningGroup.FAILS && rawJson.positions.length == 0) {
                throw new PvsStudioException("'positions' for a warning cannot be empty");
            }
            boolean isExtendedFormat = rawJson.positions.length > 0 && rawJson.positions[0].isExtendedFormat();
            for (int i = 0; i < rawJson.positions.length; ++i) {
                RawJson.Position position = rawJson.positions[i];
                String filePath = position.filePath;
                if (filePath == null) {
                    throw new PvsStudioException("Invalid source file position, file field is null");
                }
                int[] linesNumbers = position.lineNumbers;
                if (linesNumbers.length == 0) {
                    throw new PvsStudioException("'lines' for a position cannot be empty");
                }
                for (int lineNumber : linesNumbers) {
                    int correctLineNumber = lineNumber == 0 ? 1 : lineNumber;
                    this.positions.add(new WarningPosition(filePath, isExtendedFormat ? position.rowBegin : correctLineNumber, isExtendedFormat ? position.rowEnd : correctLineNumber, isExtendedFormat ? position.columnBegin : WarningPosition.DEFAULT.column, isExtendedFormat ? position.columnEnd : WarningPosition.DEFAULT.endColumn, isExtendedFormat ? new NavigationInfo(position) : (i == 0 && linesNumbers[0] == lineNumber ? new NavigationInfo(rawJson) : null)));
                }
            }
            this.cwe = rawJson.cwe;
            if (StringUtils.isNotBlank((CharSequence)rawJson.sast)) {
                this.sastId = rawJson.sast.trim();
            }
            if (rawJson.projects != null) {
                this.projects.addAll(Arrays.asList(rawJson.projects.split(",")));
            }
        }
    }

    public Warning() {
    }

    public Warning(@NotNull String n, @NotNull String msg, @NotNull WarningLevel lvl, @NotNull WarningPosition sourcePosition) {
        this.code = n;
        this.level = lvl;
        this.message = msg;
        this.addSourcePosition(sourcePosition);
    }

    public Warning(@NotNull String n, @NotNull String msg, @NotNull WarningLevel lvl) {
        this(n, msg, lvl, WarningPosition.INVALID_POSITION);
    }

    public Warning(@NotNull Throwable e) {
        this(V061, Warning.messageFromException(e), WarningLevel.LEVEL_0, WarningPosition.INVALID_POSITION);
        if (e instanceof PvsStudioCoreStartupException) {
            this.code = V062;
        } else if (e instanceof PvsStudioTimeoutException) {
            this.code = V063;
        } else if (e instanceof PvsStudioEmptyLicenseException) {
            this.code = ERROR_CODE_TRIAL;
        } else if (e instanceof PvsStudioLicenseException) {
            this.code = "";
        } else if (e instanceof PvsStudioAnalyzerFailedException) {
            this.code = "";
        }
        this.addStacktrace(e);
    }

    public static String messageFromException(Throwable e) {
        Object message;
        Object object = message = e instanceof PvsStudioException ? e.getMessage() : e.toString();
        if (Strings.isNullOrEmpty((String)message)) {
            message = "Unhandled exception";
        }
        if (!((String)message).endsWith(".")) {
            message = (String)message + ".";
        }
        return message;
    }

    public Warning addStacktrace(Throwable thr) {
        StringWriter stringWriter = new StringWriter();
        thr.printStackTrace(new PrintWriter(stringWriter));
        this.stacktrace = new ArrayList<String>(Arrays.asList(stringWriter.toString().replace("\t", "    ").split(System.lineSeparator())));
        return this;
    }

    public Optional<String> getVivaUrl() {
        if (this.code.equals(ERROR_CODE_RENEW)) {
            return Optional.of("https://pvs-studio.com/en/renewal/");
        }
        if (this.code.equals(ERROR_CODE_UPDATE)) {
            return Optional.of("https://pvs-studio.com/en/pvs-studio/download/");
        }
        if (this.code.equals(ERROR_CODE_TRIAL)) {
            return Optional.of("https://pvs-studio.com/en/pvs-studio/try-free/");
        }
        return this.getCode().map(c -> String.format("https://pvs-studio.com/en/docs/warnings/v%03d/", c));
    }

    public Optional<String> getUrlCWE() {
        return this.cwe == 0 ? Optional.empty() : Optional.of("https://cwe.mitre.org/data/definitions/" + this.cwe + ".html");
    }

    public static Optional<Integer> getCode(@NotNull String name) {
        if (name.startsWith("V") && StringUtils.isNumeric((CharSequence)name.substring(1))) {
            return Optional.of(Integer.valueOf(name.substring(1)));
        }
        return Optional.empty();
    }

    public Optional<Integer> getCode() {
        return Warning.getCode(this.code);
    }

    public Optional<String> getAdditionalLinesString() {
        if (this.positions.size() > 1) {
            Function<WarningPosition, String> mapper = this.positions.stream().anyMatch(pos -> !Objects.equals(pos.file, this.positions.get((int)0).file)) ? pos -> String.format("%s:%d", pos.file == null ? "" : new File(pos.file).getName(), pos.line) : pos -> String.valueOf(pos.line);
            String res = this.positions.stream().map(mapper).distinct().collect(Collectors.joining(", "));
            if (res.contains(",")) {
                return Optional.of(res);
            }
        }
        return Optional.empty();
    }

    public boolean isSameAdditionalLinesFile() {
        if (this.positions.size() > 1) {
            String first = this.positions.get((int)0).file;
            return first != null && this.positions.stream().allMatch(pos -> first.equals(pos.file));
        }
        return true;
    }

    public Warning addSuffix(@NotNull String suffix) {
        assert (this.message.endsWith("."));
        assert (suffix.endsWith("."));
        this.message = String.format("%s %s", this.message, suffix);
        return this;
    }

    public Warning addSourcePosition(@NotNull WarningPosition warningPosition) {
        if (warningPosition != WarningPosition.INVALID_POSITION) {
            this.positions.add(warningPosition);
        }
        return this;
    }

    public Warning addSourcePositions(@NotNull Iterable<WarningPosition> warningPositions) {
        for (WarningPosition position : warningPositions) {
            this.addSourcePosition(position);
        }
        return this;
    }

    public Warning setLevel(WarningLevel l) {
        this.level = l;
        return this;
    }

    public Warning setCwe(int value) {
        this.cwe = value;
        return this;
    }

    public Warning setSastId(String value) {
        this.sastId = value;
        return this;
    }

    public static boolean isAnalyzerErrorCode(@NotNull String errStr) {
        int length = errStr.length();
        if (length != 4 && length != 5) {
            return false;
        }
        if (errStr.charAt(0) != 'V' && errStr.charAt(0) != 'v') {
            return false;
        }
        for (int i = 1; i <= 3; ++i) {
            if (Character.isDigit(errStr.charAt(i))) continue;
            return false;
        }
        if (length == 5) {
            return Character.isDigit(errStr.charAt(4));
        }
        return true;
    }

    public static int getHashCodePVS(@NotNull String msg) {
        boolean continueSearch;
        do {
            continueSearch = false;
            int index = msg.lastIndexOf("//-");
            if (index == -1) continue;
            String subStr = msg.substring(index + 3);
            continueSearch = Warning.isAnalyzerErrorCode(subStr = StringUtils.stripEnd((String)subStr, null));
            if (!continueSearch) continue;
            msg = msg.substring(0, index);
        } while (continueSearch);
        long sum = 0L;
        for (int i = 0; i < msg.length(); ++i) {
            char cur = msg.charAt(i);
            if (cur >= '\u0080' || cur == ' ' || cur == '\t') continue;
            boolean hiBit = (sum & 0x80000000L) != 0L;
            sum <<= 1;
            sum ^= (long)cur;
            if (hiBit) {
                sum ^= 1L;
            }
            sum &= 0xFFFFFFFFFFFFFFFFL;
        }
        return (int)sum;
    }

    @NotNull
    public static String removeTrailingComments(@NotNull String line) {
        boolean isInsideString = false;
        for (int i = 0; i < line.length() - 1; ++i) {
            if (line.charAt(i) == '\"' && (i == 0 || line.charAt(i - 1) != '\\')) {
                isInsideString = !isInsideString;
                continue;
            }
            if (isInsideString || line.charAt(i) != '/' || line.charAt(i + 1) != '/') continue;
            return line.substring(0, i);
        }
        return line;
    }

    @NotNull
    public static String removeInlineComments(@NotNull CharSequence input) {
        StringBuilder stringBuilder = new StringBuilder(input);
        boolean inStringLiteral = false;
        boolean inTextBlock = false;
        boolean inComment = false;
        int commentStartIndex = -1;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char nextChar;
            char ch = stringBuilder.charAt(i);
            if (ch == '\"') {
                char[] next;
                if (i - 1 <= 0 || stringBuilder.charAt(i - 1) == '\\') continue;
                if (i + 1 < stringBuilder.length() - 1 && i + 2 < stringBuilder.length() - 1 && (next = new char[]{stringBuilder.charAt(i + 1), stringBuilder.charAt(i + 2)})[0] == '\"' && next[1] == '\"') {
                    i += 2;
                    inTextBlock = !inTextBlock;
                    continue;
                }
                if (inTextBlock) continue;
                inStringLiteral = !inStringLiteral;
                continue;
            }
            if (ch == '/') {
                char nextChar2;
                if (inStringLiteral || inTextBlock || inComment || i + 1 > stringBuilder.length() - 1 || (nextChar2 = stringBuilder.charAt(i + 1)) != '*') continue;
                inComment = true;
                commentStartIndex = i;
                continue;
            }
            if (ch != '*' || !inComment || inStringLiteral || inTextBlock || i + 1 > stringBuilder.length() - 1 || (nextChar = stringBuilder.charAt(i + 1)) != '/') continue;
            inComment = false;
            if (i + 2 < stringBuilder.length() && stringBuilder.charAt(i + 2) == ' ') {
                stringBuilder.replace(i + 2, i + 3, "");
            }
            stringBuilder.replace(commentStartIndex, i + 2, "");
            int difference = i - commentStartIndex + 1;
            i -= difference;
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String fixErrorString(@NotNull String line) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            int cur = line.charAt(i);
            if (Character.isDigit((char)cur)) {
                while (i < line.length() - 1 && Character.isDigit(line.charAt(i + 1))) {
                    ++i;
                }
                cur = 95;
            } else if (Character.isSpaceChar((char)cur)) {
                while (i < line.length() - 1 && Character.isSpaceChar(line.charAt(i + 1))) {
                    ++i;
                }
                cur = 32;
            }
            res.append((char)cur);
        }
        return Warning.removeTrailingComments(res.toString()).trim();
    }

    @NotNull
    public Optional<WarningPosition> getFirstPosition() {
        return this.positions.stream().findFirst();
    }

    @NotNull
    public WarningGroup getGroup() {
        return WarningGroup.byCode(this.getCode().orElse(0));
    }

    @NotNull
    public static String getPositionsString(@NotNull List<WarningPosition> positions) {
        LinkedList<Pair> compactPositions = new LinkedList<Pair>();
        for (WarningPosition position : positions) {
            String positionFilePath = position.file;
            if (positionFilePath == null) continue;
            int positionLine = position.line;
            if (compactPositions.isEmpty() || !((String)((Pair)compactPositions.getLast()).getKey()).equals(positionFilePath)) {
                compactPositions.add(Pair.of((Object)positionFilePath, new ArrayList<Integer>(Collections.singleton(positionLine))));
                continue;
            }
            ((List)((Pair)compactPositions.getLast()).getValue()).add(positionLine);
        }
        return compactPositions.stream().map(cp -> ((String)cp.getKey()).isEmpty() && ((List)cp.getValue()).size() == 1 && (Integer)((List)cp.getValue()).get(0) == 1 ? "" : String.format("%s:%s", new File((String)cp.getKey()).getName(), ((List)cp.getValue()).stream().map(String::valueOf).collect(Collectors.joining(",")))).collect(Collectors.joining(" "));
    }
}

