/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedWriter;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFormat
implements WarningsOutput {
    @Override
    @NotNull
    public String[] names() {
        return new String[]{"txt", "text"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"txt"};
    }

    @Override
    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings, @NotNull BufferedWriter writer) throws IOException {
        for (Warning w : warnings) {
            if (w.falseAlarm) continue;
            String message = w.message;
            Object code = w.code;
            if (((String)code).equals("Renew")) {
                message = w.message.replace("Click 'Renew'", "Follow the link `https://pvs-studio.com/en/renewal/`");
                code = (String)code + ".";
            }
            String type = w.level.match("Fail", "High", "Medium", "Low");
            writer.write(type);
            writer.write(": ");
            writer.write((String)code);
            writer.write(" ");
            if (w.cwe != 0) {
                writer.write(String.format("[CWE-%d] ", w.cwe));
            }
            writer.write(message);
            writer.write(" ");
            writer.write(w.positions.toString());
            writer.write(System.lineSeparator());
        }
    }
}

