/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedWriter;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TasksFormat
implements WarningsOutput {
    @Override
    @NotNull
    public String[] names() {
        return new String[]{"tasks", "tasklist"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"tasks"};
    }

    @Override
    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings, @NotNull BufferedWriter writer) throws IOException {
        for (Warning w : warnings) {
            if (w.falseAlarm) continue;
            String suffix = "";
            String file = null;
            int line = 1;
            if (!w.positions.isEmpty()) {
                file = w.positions.get((int)0).file;
                line = w.positions.get((int)0).line;
            }
            if (w.positions.size() > 1) {
                suffix = String.format(" Check lines: %s.", w.getAdditionalLinesString());
            }
            String securityPrefix = "";
            if (w.cwe != 0) {
                securityPrefix = String.format("[CWE-%d] ", w.cwe);
            }
            writer.write(String.format("%s\t%d\t%s\t%s %s%s%n", file != null ? file : "pvs-studio", line, w.level.match("err", "warn", "note"), w.code, String.format("%s%s", securityPrefix, w.message), suffix));
        }
    }
}

