/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.pvsstudio.warnings.SuppressBase;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressBaseLoader {
    private static final String SUPPRESS_BASE_INVALID_MESSAGE_FORMAT = "ERROR: %s is invalid.%n";
    private final Gson gson;
    @NotNull
    private final File suppressBasePath;

    public SuppressBaseLoader(@NotNull File suppressBasePath, boolean lenient) {
        this.suppressBasePath = suppressBasePath;
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (lenient) {
            gsonBuilder = gsonBuilder.setLenient();
        }
        this.gson = gsonBuilder.create();
    }

    @NotNull
    public String getSuppressBaseInvalidMessage() {
        return String.format(SUPPRESS_BASE_INVALID_MESSAGE_FORMAT, this.suppressBasePath.getPath());
    }

    @Nullable
    public SuppressBase load() throws JsonParseException, IOException {
        if (!this.suppressBasePath.exists()) {
            return new SuppressBase();
        }
        try (FileReader reader = new FileReader(this.suppressBasePath);){
            SuppressBase suppressBase = (SuppressBase)this.gson.fromJson((Reader)reader, SuppressBase.class);
            return suppressBase;
        }
    }
}

