/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.google.gson.annotations.SerializedName;
import com.pvsstudio.warnings.Warning;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SuppressBase {
    @SerializedName(value="warnings")
    @NotNull
    public Set<SuppressedWarning> suppressedWarnings = new HashSet<SuppressedWarning>();
    public final int version;

    public SuppressBase() {
        this.version = 1;
    }

    public SuppressBase(int version) {
        this.version = version;
    }

    public boolean isSuppressed(@NotNull Warning warning) {
        return this.suppressedWarnings.contains(new SuppressedWarning(warning));
    }

    public void clear() {
        this.suppressedWarnings.clear();
    }

    public boolean add(@NotNull Warning warning) {
        return this.suppressedWarnings.add(new SuppressedWarning(warning));
    }

    public boolean addAll(@NotNull Collection<Warning> warnings) {
        boolean changed = false;
        for (Warning warning : warnings) {
            changed |= this.add(warning);
        }
        return changed;
    }

    public void addAllSuppressedWarningsFrom(@NotNull SuppressBase suppressBase) {
        this.suppressedWarnings.addAll(suppressBase.suppressedWarnings);
    }

    public static class SuppressedWarning {
        @SerializedName(value="FileName")
        @NotNull
        public String fileName = "";
        @SerializedName(value="ErrorCode")
        @NotNull
        public String errorCode = "";
        @SerializedName(value="Message")
        @NotNull
        public String message = "";
        @SerializedName(value="CodePrev")
        public int codePrev = 0;
        @SerializedName(value="CodeCurrent")
        public int codeCurrent = 0;
        @SerializedName(value="CodeNext")
        public int codeNext = 0;

        public SuppressedWarning() {
        }

        public SuppressedWarning(@NotNull Warning warning) {
            this.errorCode = warning.code;
            this.message = Warning.fixErrorString(warning.message);
            warning.getFirstPosition().ifPresent(firstPosition -> {
                String file = firstPosition.file;
                if (file != null) {
                    this.fileName = new File(file).getName();
                }
                if (firstPosition.navigation != null) {
                    this.codePrev = firstPosition.navigation.previousLine;
                    this.codeCurrent = firstPosition.navigation.currentLine;
                    this.codeNext = firstPosition.navigation.nextLine;
                }
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SuppressedWarning)) {
                return false;
            }
            SuppressedWarning w2 = (SuppressedWarning)o;
            return this.fileName.equals(w2.fileName) && this.errorCode.equals(w2.errorCode) && this.message.equals(w2.message) && this.codePrev == w2.codePrev && this.codeCurrent == w2.codeCurrent && this.codeNext == w2.codeNext;
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.errorCode, this.message);
        }
    }
}

