/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningPosition;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleHtmlOutput
implements WarningsOutput {
    private final int defaultCweColumnWidth = 6;
    private final int defaultOwaspColumnWidth = 9;
    private final int defaultMessageColumnWidth = 65;
    private final WarningsSet info = WarningsSet.createNew();
    private final WarningsSet ga = WarningsSet.createNew();
    private final WarningsSet owasp = WarningsSet.createNew();

    @Override
    @NotNull
    public String[] names() {
        return new String[]{"html"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"html"};
    }

    private String escapeHtml(@Nullable String src) {
        if (src == null) {
            return "";
        }
        return src.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private void printTableCaption(@NotNull BufferedWriter writer) throws IOException {
        writer.write(String.format("%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s", "    <caption style=\"font-weight: bold;background: #fff;color: #000;border: none !important;\">MESSAGES</caption>", "    <tr style=\"background: black; color: white;\">", "      <th style=\"width: 30%;\">Location</th>", "      <th style=\"width: 5%;\">Code</th>", String.format("      <th style=\"width: %d%%;\">CWE</th>", 6), String.format("      <th style=\"width: %d%%;\">SAST</th>", 9), String.format("      <th style=\"width: %d%%;\">Message</th>", 65), "    </tr>"));
    }

    void printMessages(@NotNull BufferedWriter writer, @NotNull WarningsSet warnings, @NotNull String caption) throws IOException {
        if (warnings.isEmpty()) {
            return;
        }
        writer.write(String.format("%s%n%s%n%s%n", "    <tr style='background: lightcyan;'>", String.format("      <td colspan='5' style='color: red; text-align: center; font-size:1.2em;'>%s</td>", caption), "    </tr>"));
        for (Warning w : warnings) {
            WarningPosition wp = null;
            if (w.getFirstPosition().isPresent()) {
                wp = w.getFirstPosition().get();
            }
            StringBuilder warningStr = new StringBuilder(String.format("%s%n%s%n%s%n", "    <tr>", String.format("      <td style='width: 30%%;'><div title=\"%s\">%s %s</div></td>", wp != null ? this.escapeHtml(wp.file) : "File Not Found!", wp != null && wp.file != null ? new File(wp.file).getName() : "", wp != null ? "(" + wp.line + ")" : ""), String.format("      <td style='width: 5%%;'><a target=\"_blank\" href='%s'>%s</a></td>", w.getVivaUrl().isPresent() ? w.getVivaUrl().get() : "Page Not Found!", w.code)));
            if (w.cwe != 0) {
                warningStr.append(String.format("      <td style='width: %d%%;'><a target=\"_blank\" href='%s'>%s</a></td>%n", 6, w.getUrlCWE().isPresent() ? w.getUrlCWE().get() : "Page Not Found!", String.format("CWE-%d", w.cwe)));
            } else {
                warningStr.append(String.format("      <th style=\"width: %d%%;\"></th>%n", 6));
            }
            if (!StringUtils.isBlank((CharSequence)w.sastId)) {
                warningStr.append(String.format("      <td style='width: %d%%;'>%s</td>", 9, w.sastId));
            } else {
                warningStr.append(String.format("      <th style=\"width: %d%%;\"></th>%n", 9));
            }
            warningStr.append(String.format("%s%n%s%n", String.format("      <td style='width: %d%%;'>%s</td>", 56, this.escapeHtml(w.message)), "    </tr>"));
            writer.write(warningStr.toString());
        }
    }

    void printTableBody(@NotNull BufferedWriter writer) throws IOException {
        this.printMessages(writer, this.info, "Fails/Info");
        this.printMessages(writer, this.ga, "General Analysis (GA)");
        this.printMessages(writer, this.owasp, "OWASP");
    }

    @Override
    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings, @NotNull BufferedWriter writer) throws IOException {
        writer.write(String.format("%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n%s%n", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">", "<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">", "<head>", "  <title>Messages</title>", "  <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />", "  <style type=\"text/css\">", "    td {", "      padding: 0;", "      text-align: left;", "      vertical-align: top;", "    }", "", "    legend {", "      color: blue;", "      font: 1.2em bold Comic Sans MS Verdana;", "      text-align: center;", "    }", "  </style>", "</head>", "<body>", "  <table style=\"width: 100%; font: 12pt normal Century Gothic;\">"));
        if (warnings.isEmpty()) {
            writer.write(String.format("No messages generated%n", new Object[0]));
        } else {
            block4: for (Warning w : warnings) {
                switch (w.getGroup()) {
                    case GA: {
                        this.ga.add(w);
                        continue block4;
                    }
                    case OWASP: {
                        this.owasp.add(w);
                        continue block4;
                    }
                }
                this.info.add(w);
            }
            this.printTableCaption(writer);
            this.printTableBody(writer);
        }
        writer.write(String.format("%s%n%s%n%s%n", "  </table>", "</body>", "</html>"));
    }
}

