/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.google.gson.JsonParseException;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.RawJson;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import com.pvsstudio.warnings.WarningsInput;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawLogFormat
implements WarningsOutput,
WarningsInput {
    @NotNull
    private static final int[] EMPTY_LINES = new int[0];
    @NotNull
    private static final String[] EMPTY_NAMES = new String[0];
    @NotNull
    private static final String INCORRECT_LICENSE = "License information is incorrect.";
    @NotNull
    private static final int[] DECODE_MAP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 102, 91, 93, 94, 65, 58, 33, 99, 47, 92, 51, 42, 84, 105, 83, 120, 81, 73, 108, 62, 87, 106, 77, 64, 111, 98, 122, 40, 69, 115, 110, 79, 76, 74, 125, 82, 126, 44, 68, 55, 71, 72, 50, 95, 104, 88, 39, 66, 109, 78, 34, 48, 70, 97, 54, 90, 56, 37, 38, 53, 80, 119, 41, 100, 75, 114, 52, 32, 123, 89, 121, 85, 117, 57, 103, 112, 96, 61, 59, 116, 124, 36, 86, 107, 43, 101, 118, 45, 49, 60, 63, 67, 35, 46, 113, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};

    @Override
    @NotNull
    public String[] names() {
        return new String[]{"log"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"log", "pvslog"};
    }

    @Override
    @NotNull
    public WarningsSet read(@NotNull BufferedReader reader, @Nullable BiConsumer<Integer, Integer> func) throws IOException {
        String line;
        boolean isDecoding = false;
        WarningsSet res = WarningsSet.createNew();
        while ((line = reader.readLine()) != null) {
            Warning warning;
            if (line.startsWith("#")) continue;
            if (line.equals("d99cf3ba-6fcd-43f9-9260-1179fa3a9bed")) {
                isDecoding = true;
                continue;
            }
            if (isDecoding) {
                line = this.decode(line);
            }
            if ((warning = this.readWarning(line)) == null) continue;
            res.add(warning);
        }
        return res;
    }

    @NotNull
    private String decode(@NotNull String line) {
        byte[] decoded = line.getBytes();
        for (int i = 0; i < decoded.length; ++i) {
            decoded[i] = (byte)(DECODE_MAP[decoded[i] & 0xFF] & 0xFF);
        }
        line = new String(decoded);
        return line;
    }

    private Warning readWarning(@NotNull String input) {
        Warning warning;
        try {
            String[] tokens = input.split("<#~>", -1);
            if (tokens.length == 1) {
                try {
                    return new Warning(RawJson.parse(input));
                }
                catch (JsonParseException e) {
                    return null;
                }
            }
            if (tokens.length != 13 && tokens.length != 14 || !tokens[0].equals("Viva64-EM")) {
                String msg = input.contains(INCORRECT_LICENSE) ? "License information is incorrect. Please check your registration data or contact Customer Support via the Feedback form on pvs-studio.com." : String.format("Incorrect input line: %s.", input);
                return new Warning("", msg, WarningLevel.LEVEL_0);
            }
            int lineNo = tokens[2].isEmpty() ? 1 : Integer.parseInt(tokens[2]);
            String filePath = tokens[3].isEmpty() ? null : tokens[3];
            String codeRule = tokens[5];
            String message = tokens[6];
            boolean isFalseAlarm = Boolean.parseBoolean(tokens[7]);
            WarningLevel level = tokens[8].isEmpty() ? WarningLevel.LEVEL_0 : WarningLevel.values()[Integer.parseInt(tokens[8])];
            String previousLine = tokens[9];
            int prevCode = Warning.getHashCodePVS(previousLine);
            String currentLine = tokens[10];
            int currentCode = Warning.getHashCodePVS(currentLine);
            String nextLine = tokens[11];
            int nextCode = Warning.getHashCodePVS(nextLine);
            int[] additionalLines = tokens[12].isEmpty() ? EMPTY_LINES : Arrays.stream(tokens[12].split(",")).map(String::trim).mapToInt(Integer::valueOf).toArray();
            String[] alternativeNames = tokens.length == 14 && !tokens[13].isEmpty() ? tokens[13].split(",") : EMPTY_NAMES;
            warning = new Warning(codeRule, message, level);
            IntStream.concat(IntStream.of(lineNo), IntStream.of(additionalLines)).distinct().mapToObj(i -> new WarningPosition(filePath, i, i, 1, Integer.MAX_VALUE, i == 0 ? new NavigationInfo(prevCode, currentCode, nextCode) : null)).forEachOrdered(warning::addSourcePosition);
            warning.falseAlarm = isFalseAlarm;
            warning.cwe = Arrays.stream(alternativeNames).filter(n -> n.startsWith("CWE-")).map(n -> Integer.valueOf(n.substring(4))).findFirst().orElse(0);
        }
        catch (Exception e) {
            warning = new Warning("V003", e.toString(), WarningLevel.LEVEL_0);
        }
        return warning;
    }

    @Override
    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings, @NotNull BufferedWriter writer) throws IOException {
        for (Warning w : warnings) {
            String additionalLines = w.isSameAdditionalLinesFile() ? w.getAdditionalLinesString().orElse("") : "";
            String suffix = w.getAdditionalLinesString().map(s -> String.format(" Check lines: %s.", s)).orElse("");
            String file = null;
            int line = 1;
            if (!w.positions.isEmpty()) {
                file = w.positions.get((int)0).file;
                line = w.positions.get((int)0).line;
            }
            String securityPrefix = "";
            if (w.cwe != 0) {
                securityPrefix = String.format("CWE-%d", w.cwe);
            }
            writer.write(String.format("Viva64-EM<#~>full<#~>%s<#~>%s<#~>error<#~>%s<#~>%s%s<#~>%s<#~>%d<#~>%s<#~>%s<#~>%s<#~>%s<#~>%s%n", line, file != null ? file : "pvs-studio", w.code, w.message, suffix, w.falseAlarm ? "true" : "false", w.level.ordinal(), 0, 0, 0, additionalLines, securityPrefix));
        }
    }
}

