/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningPosition;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RawJson {
    public static final Gson GSON_CONFIG = new Gson();
    @SerializedName(value="code")
    public String code = "";
    @SerializedName(value="message")
    public String message = "";
    @SerializedName(value="falseAlarm")
    public boolean falseAlarm;
    @SerializedName(value="level")
    public int level;
    @SerializedName(value="prevLineHash")
    public long prevLineHash;
    @SerializedName(value="currLineHash")
    public long currLineHash;
    @SerializedName(value="nextLineHash")
    public long nextLineHash;
    @SerializedName(value="prevLine")
    public String prevLine = "";
    @SerializedName(value="currLine")
    public String currLine = "";
    @SerializedName(value="nextLine")
    public String nextLine = "";
    @SerializedName(value="positions")
    public Position[] positions;
    @SerializedName(value="cwe")
    public int cwe;
    @SerializedName(value="sastId")
    public String sast;
    @SerializedName(value="projects")
    public String projects = null;
    @SerializedName(value="analyzedSourceFiles")
    public String[] analyzedSourceFiles;

    public RawJson(@NotNull Warning warning) {
        this.code = warning.code;
        this.message = warning.message;
        this.falseAlarm = warning.falseAlarm;
        this.cwe = Math.max(warning.cwe, 0);
        switch (warning.level) {
            case LEVEL_1: {
                this.level = 1;
                break;
            }
            case LEVEL_2: {
                this.level = 2;
                break;
            }
            case LEVEL_3: {
                this.level = 3;
                break;
            }
            default: {
                this.level = 0;
            }
        }
        if (warning.positions.isEmpty()) {
            this.positions = new Position[]{new Position(WarningPosition.DEFAULT)};
        } else {
            warning.getFirstPosition().ifPresent(firstPosition -> {
                if (firstPosition.navigation == null) {
                    this.prevLineHash = 0L;
                    this.currLineHash = 0L;
                    this.nextLineHash = 0L;
                } else {
                    this.prevLineHash = firstPosition.navigation.previousLine;
                    this.currLineHash = firstPosition.navigation.currentLine;
                    this.nextLineHash = firstPosition.navigation.nextLine;
                }
            });
            this.positions = (Position[])warning.positions.stream().filter(p -> p.file != null).map(Position::new).toArray(Position[]::new);
        }
        if (StringUtils.isNotBlank((CharSequence)warning.sastId)) {
            this.sast = warning.sastId.trim();
        }
    }

    public static RawJson parse(@NotNull String errorInfoLine) {
        RawJson result = (RawJson)GSON_CONFIG.fromJson(errorInfoLine, RawJson.class);
        if (result.positions == null) {
            result.positions = new Position[0];
        }
        String currentLine = result.currLine;
        if (result.currLineHash == 0L && currentLine != null) {
            result.currLineHash = Warning.getHashCodePVS(currentLine);
        }
        String previousLine = result.prevLine;
        if (result.prevLineHash == 0L && previousLine != null) {
            result.prevLineHash = Warning.getHashCodePVS(previousLine);
        }
        String nextLine = result.nextLine;
        if (result.nextLineHash == 0L && nextLine != null) {
            result.nextLineHash = Warning.getHashCodePVS(nextLine);
        }
        if (result.analyzedSourceFiles == null) {
            result.analyzedSourceFiles = new String[0];
        }
        return result;
    }

    public static class Position {
        @SerializedName(value="file")
        public String filePath = "";
        @SerializedName(value="lines")
        public int[] lineNumbers;
        @SerializedName(value="rowBegin")
        public int rowBegin;
        @SerializedName(value="rowEnd")
        public int rowEnd;
        @SerializedName(value="columnBegin")
        public int columnBegin;
        @SerializedName(value="columnEnd")
        public int columnEnd;
        @SerializedName(value="hashPrev")
        public long hashPrev;
        @SerializedName(value="hashCurr")
        public long hashCurr;
        @SerializedName(value="hashNext")
        public long hashNext;

        public Position(@NotNull WarningPosition warningPosition) {
            this.filePath = warningPosition.file != null ? warningPosition.file : "";
            int warningPositionLine = warningPosition.line;
            this.lineNumbers = new int[]{warningPositionLine};
            this.rowBegin = warningPositionLine;
            this.rowEnd = warningPosition.endLine;
            this.columnBegin = warningPosition.column;
            this.columnEnd = warningPosition.endColumn;
            if (warningPosition.navigation == null) {
                this.hashPrev = 0L;
                this.hashCurr = 0L;
                this.hashNext = 0L;
            } else {
                this.hashPrev = warningPosition.navigation.previousLine;
                this.hashCurr = warningPosition.navigation.currentLine;
                this.hashNext = warningPosition.navigation.nextLine;
            }
        }

        public boolean isExtendedFormat() {
            return this.rowBegin > 0 && this.rowEnd > 0 && this.columnBegin > 0 && this.columnEnd > 0;
        }
    }
}

