/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.warnings.RawJson;
import com.pvsstudio.warnings.Warning;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationInfo {
    public static final int FIELD_DEFAULT_VALUE = 0;
    public static final NavigationInfo EMPTY = new NavigationInfo((NavigationInfo)null);
    public final int previousLine;
    public final int currentLine;
    public final int nextLine;
    public final int columns;

    public NavigationInfo(@Nullable NavigationInfo navigationInfo) {
        if (navigationInfo != null) {
            this.previousLine = navigationInfo.previousLine;
            this.currentLine = navigationInfo.currentLine;
            this.nextLine = navigationInfo.nextLine;
            this.columns = navigationInfo.columns;
        } else {
            this.previousLine = 0;
            this.currentLine = 0;
            this.nextLine = 0;
            this.columns = 0;
        }
    }

    public NavigationInfo(@NotNull RawJson rawJson) {
        this.previousLine = (int)rawJson.prevLineHash;
        this.currentLine = (int)rawJson.currLineHash;
        this.nextLine = (int)rawJson.nextLineHash;
        this.columns = 0;
    }

    public NavigationInfo(@NotNull RawJson.Position rawJsonPosition) {
        this.previousLine = (int)rawJsonPosition.hashPrev;
        this.currentLine = (int)rawJsonPosition.hashCurr;
        this.nextLine = (int)rawJsonPosition.hashNext;
        this.columns = 0;
    }

    public NavigationInfo(int previousLine, int currentLine, int nextLine) {
        this.previousLine = previousLine;
        this.currentLine = currentLine;
        this.nextLine = nextLine;
        this.columns = 0;
    }

    public NavigationInfo(@NotNull String previousLine, @NotNull String currentLine, @NotNull String nextLine) {
        this.previousLine = Warning.getHashCodePVS(previousLine);
        this.currentLine = Warning.getHashCodePVS(currentLine);
        this.nextLine = Warning.getHashCodePVS(nextLine);
        this.columns = 0;
    }
}

