/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import com.pvsstudio.warnings.WarningsInput;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonFormat
implements WarningsInput,
WarningsOutput {
    Document json = null;
    private static final String ProjectNameContainingTFPattern = "(.*\\(netcoreapp\\d+.\\d+\\)$)|(.*\\(netstandard\\d+.\\d+\\)$)|(.*\\(net\\d+\\)$)|(.*\\(net\\d+.\\d+\\)$)";
    private static final Pattern ProjectNameContainingTFRegex = Pattern.compile("(.*\\(netcoreapp\\d+.\\d+\\)$)|(.*\\(netstandard\\d+.\\d+\\)$)|(.*\\(net\\d+\\)$)|(.*\\(net\\d+.\\d+\\)$)");

    @Override
    @NotNull
    public String[] names() {
        return new String[]{"json"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"json"};
    }

    private Gson gson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(WarningLevel.class, (Object)new LevelSerializer()).registerTypeAdapter(WarningPosition.class, (Object)new PositionSerializer()).create();
    }

    @Override
    @NotNull
    public WarningsSet read(@NotNull BufferedReader reader, @Nullable BiConsumer<Integer, Integer> funcOutputAboutIncorrectVersion) {
        this.json = new Document();
        WarningsSet set = WarningsSet.createNew();
        JsonObject jsonObject = (JsonObject)new JsonParser().parse((Reader)new BufferedReader(reader));
        JsonElement jsonElement = jsonObject.get("version");
        if (jsonElement == null) {
            return set;
        }
        int jsonVersion = jsonElement.getAsInt();
        if (jsonVersion > this.json.version && funcOutputAboutIncorrectVersion != null) {
            funcOutputAboutIncorrectVersion.accept(jsonElement.getAsInt(), this.json.version);
            return set;
        }
        this.json = (Document)this.gson().fromJson((JsonElement)jsonObject, Document.class);
        if (this.json.warnings != null) {
            set.addAll((Collection<? extends Warning>)this.json.warnings);
        }
        if (jsonVersion < 3) {
            for (Warning warning : set) {
                List projectsNamesWithoutTargetingFramework = warning.projects.stream().map(JsonFormat::tryGetProjectNameWithoutTargetingFramework).collect(Collectors.toList());
                warning.projects.clear();
                warning.projects.addAll(projectsNamesWithoutTargetingFramework);
            }
        }
        return set;
    }

    public static String tryGetProjectNameWithoutTargetingFramework(@Nullable String projectName) {
        if (StringUtils.isEmpty((CharSequence)projectName) || !projectName.endsWith(")") || !ProjectNameContainingTFRegex.matcher(projectName).find()) {
            return projectName;
        }
        int indexOpeningParenthesis = projectName.lastIndexOf(40);
        if (indexOpeningParenthesis == -1) {
            return projectName;
        }
        return projectName.substring(0, indexOpeningParenthesis);
    }

    @Override
    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings, @NotNull BufferedWriter writer) {
        this.json = new Document();
        this.json.warnings = warnings;
        this.gson().toJson((Object)this.json, (Appendable)writer);
    }

    @Nullable
    public Collection<Warning> getWarnings() {
        return this.json.warnings;
    }

    private static class Document {
        final int version = 3;
        Collection<Warning> warnings = null;

        private Document() {
        }
    }

    private static class LevelSerializer
    implements JsonSerializer<WarningLevel>,
    JsonDeserializer<WarningLevel> {
        private LevelSerializer() {
        }

        public WarningLevel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return WarningLevel.values()[json.getAsInt()];
        }

        public JsonElement serialize(WarningLevel src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.ordinal());
        }
    }

    private static class PositionSerializer
    implements JsonSerializer<WarningPosition>,
    JsonDeserializer<WarningPosition> {
        private PositionSerializer() {
        }

        private int get(JsonObject object, String field, int defaultValue) {
            JsonElement res = object.get(field);
            return res == null ? defaultValue : res.getAsInt();
        }

        private String get(JsonObject object, String field, String defaultValue) {
            JsonElement res = object.get(field);
            return res == null ? defaultValue : res.getAsString();
        }

        public WarningPosition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            WarningPosition position;
            JsonObject object = json.getAsJsonObject();
            String file = this.get(object, "file", null);
            int line = this.get(object, "line", 1);
            int endLine = this.get(object, "endLine", line);
            int column = this.get(object, "column", 1);
            int endColumn = this.get(object, "endColumn", column);
            JsonElement navigationJson = object.get("navigation");
            NavigationInfo navigation = navigationJson == null || navigationJson.isJsonNull() ? null : (NavigationInfo)context.deserialize(navigationJson, NavigationInfo.class);
            try {
                position = new WarningPosition(file, line, endLine, column, endColumn, navigation);
            }
            catch (PvsStudioException e) {
                return WarningPosition.DEFAULT;
            }
            return position;
        }

        public JsonElement serialize(WarningPosition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            if (src.file != null) {
                object.addProperty("file", src.file);
            }
            object.addProperty("line", (Number)src.line);
            object.addProperty("endLine", (Number)src.endLine);
            object.addProperty("column", (Number)src.column);
            object.addProperty("endColumn", (Number)src.endColumn);
            if (src.navigation != null) {
                object.add("navigation", context.serialize((Object)src.navigation));
            }
            return object;
        }
    }
}

