/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.warnings;

import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningPosition;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorfileFormat
implements WarningsOutput {
    @Override
    @NotNull
    public String[] names() {
        return new String[]{"errorfile"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"err"};
    }

    @Override
    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings, @NotNull BufferedWriter writer) throws IOException {
        for (Warning w : warnings) {
            if (w.falseAlarm) continue;
            String type = w.level.match("error", "warning", "note");
            String securityPrefix = "";
            if (w.cwe != 0) {
                securityPrefix = String.format("[CWE-%d] ", w.cwe);
            }
            String message = String.format("%s%s", securityPrefix, w.message);
            if (w.positions.isEmpty()) {
                writer.write(String.format("%s: %s %s%n", type, w.code, message));
                continue;
            }
            List<WarningPosition> positions = w.positions;
            writer.write(String.format("%s: %s: %s %s%n", positions.get(0), type, w.code, message));
            for (WarningPosition position : positions.subList(1, positions.size())) {
                if (position.line == positions.get((int)0).line && Objects.equals(position.file, positions.get((int)0).file)) continue;
                writer.write(String.format("%s: see also%n", position));
            }
        }
    }
}

