/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.visitors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;

public class StringConcatenationVisitor
extends EarlyTerminatingScanner<Boolean> {
    private static final List<String> CONCATENATION_LIKE_METHOD_NAMES = List.of("concat", "format", "join");
    private static final String STRING_QUALIFIED_NAME = String.class.getName();
    private static final int DEFAULT_MAX_INTERPROCEDURAL_DEEP = 3;
    private final int maxInterproceduralDeep;
    private int currentInterproceduralDeep;

    public StringConcatenationVisitor() {
        this(3);
    }

    public StringConcatenationVisitor(int maxInterproceduralDeep) {
        this.maxInterproceduralDeep = maxInterproceduralDeep;
    }

    public static boolean hasConcatenation(CtElement element) {
        StringConcatenationVisitor visitor = new StringConcatenationVisitor();
        visitor.scan(element);
        return visitor.getResult();
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() == BinaryOperatorKind.PLUS) {
            this.terminate();
            return;
        }
        super.visitCtBinaryOperator(operator);
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        if (assignment.getKind() == BinaryOperatorKind.PLUS) {
            this.terminate();
            return;
        }
        super.visitCtOperatorAssignment(assignment);
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        if (executable != null && StringConcatenationVisitor.isConcatLike(executable) && StringConcatenationVisitor.isString(executable.getType())) {
            this.terminate();
            return;
        }
        super.visitCtInvocation(invocation);
    }

    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        super.visitCtExecutableReference(reference);
        if (!StringConcatenationVisitor.isString(reference.getType())) {
            return;
        }
        if (this.currentInterproceduralDeep + 1 <= this.maxInterproceduralDeep) {
            ++this.currentInterproceduralDeep;
            this.scan((CtElement)reference.getDeclaration());
            --this.currentInterproceduralDeep;
        }
    }

    protected void terminate() {
        this.setResult(true);
        super.terminate();
    }

    @NotNull
    public Boolean getResult() {
        return Boolean.TRUE.equals(super.getResult());
    }

    private static boolean isConcatLike(CtExecutableReference<?> executableReference) {
        return CONCATENATION_LIKE_METHOD_NAMES.contains(executableReference.getSimpleName());
    }

    private static boolean isString(CtTypeReference<?> typeReference) {
        return typeReference != null && STRING_QUALIFIED_NAME.equals(typeReference.getQualifiedName());
    }
}

