/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.visitors;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTry;

public abstract class StatementWalker {
    private final CtStatement initialStatement;
    private boolean isTerminated = false;

    public StatementWalker(CtStatement statement) {
        this.initialStatement = statement;
    }

    protected void terminate() {
        this.isTerminated = true;
    }

    private void walk(CtStatement statement, Path path) {
        CtStatement body;
        if (this.isTerminated) {
            return;
        }
        if (statement instanceof CtIf) {
            CtStatement elseBranch;
            Path ifPath = new Path(statement, path);
            CtStatement thenBranch = ((CtIf)statement).getThenStatement();
            if (thenBranch != null) {
                this.walk(thenBranch, ifPath);
            }
            if ((elseBranch = ((CtIf)statement).getElseStatement()) != null) {
                this.walk(elseBranch, ifPath);
            }
            return;
        }
        if (statement instanceof CtSwitch) {
            Path switchPath = new Path(statement, path);
            for (CtCase ctCase : ((CtSwitch)statement).getCases()) {
                this.walk((CtStatement)ctCase, new Path((CtStatement)ctCase, switchPath));
            }
            return;
        }
        if (statement instanceof CtTry) {
            Path tryPath = new Path(statement, path);
            CtTry tryStatement = (CtTry)statement;
            if (tryStatement.getBody() != null) {
                this.walk((CtStatement)tryStatement.getBody(), tryPath);
            }
            for (CtCatch ctCatch : tryStatement.getCatchers()) {
                this.walk((CtStatement)ctCatch.getBody(), tryPath);
            }
            if (tryStatement.getFinalizer() != null) {
                this.walk((CtStatement)tryStatement.getFinalizer(), tryPath);
            }
            return;
        }
        CtStatementList nestedStatements = null;
        if (statement instanceof CtStatementList) {
            nestedStatements = (CtStatementList)statement;
        } else if (statement instanceof CtSynchronized) {
            nestedStatements = ((CtSynchronized)statement).getBlock();
        } else if (statement instanceof CtBodyHolder && (body = ((CtBodyHolder)statement).getBody()) instanceof CtStatementList) {
            nestedStatements = (CtStatementList)body;
        }
        if (nestedStatements != null) {
            Path nestedPath = new Path(statement, path);
            for (CtStatement stmt : nestedStatements) {
                this.walk(stmt, nestedPath);
            }
        } else {
            this.onStatement(statement, path);
        }
    }

    public final void walk() {
        this.isTerminated = false;
        this.walk(this.initialStatement, new Path());
    }

    protected abstract void onStatement(CtStatement var1, Path var2);

    public static class Path {
        private final CtStatement statement;
        private final Path parent;

        private Path() {
            this.statement = null;
            this.parent = null;
        }

        private Path(CtStatement statement, Path parent) {
            this.statement = statement;
            this.parent = parent;
        }

        @Nullable
        public CtStatement getStatement() {
            return this.statement;
        }

        @Nullable
        public Path getParent() {
            return this.parent;
        }

        public boolean isInsideOf(@NotNull Path path) {
            Path currentParent = this.parent;
            while (currentParent != null) {
                if (currentParent == path) {
                    return true;
                }
                currentParent = currentParent.parent;
            }
            return false;
        }
    }
}

