/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.visitors;

import com.pvsstudio.PvsStudioTimeoutException;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.runner.Benchmark;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import com.pvsstudio.visitors.DataFlowVisitor;
import com.pvsstudio.warnings.Warning;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;

public class PvsStudioVisitor
extends DataFlowVisitor {
    private static final Logger logger = LoggerFactory.getLogger(PvsStudioVisitor.class);
    private final PvsStudioAnalyzer analyzer;

    public PvsStudioVisitor(@NotNull PvsStudioAnalyzer analyzer) {
        super(analyzer.getDataFlow());
        this.analyzer = analyzer;
    }

    private void runRules(Consumer<PvsStudioRule> runnable, BiConsumer<String, Runnable> runner, boolean isUnreachable, boolean isInFirstIteration) {
        this.analyzer.getRules().stream().filter(PvsStudioRule::shouldBeExecuted).filter(r -> !isInFirstIteration || r.isEnabledInFirstIteration()).filter(r -> !isUnreachable || r.isEnabledInUnreachableCode()).forEach(r -> {
            try {
                runner.accept(r.getName(), () -> runnable.accept((PvsStudioRule)((Object)r)));
            }
            catch (PvsStudioTimeoutException timeoutException) {
                throw timeoutException;
            }
            catch (Exception e) {
                String ruleName = r.getName();
                Warning warning = Warning.ruleExceptionWarning(e, ruleName);
                if (this.analyzer.getConfig().loggingIsEnabled() && this.analyzer.getConfig().debugLog != null) {
                    warning.message = warning.message + String.format(" Detailed logs are located at '%s'.", this.analyzer.getConfig().debugLog);
                }
                warning.addSourcePosition(RulesUtils.getPosition(this.analyzer.getLastVisitedElement(), this.analyzer.getModule()));
                this.analyzer.getWarnings().add(warning);
                logger.error("An exception occurred during execution of the '{}' rule.", (Object)ruleName, (Object)e);
            }
        });
    }

    @Override
    public void scan(CtElement e) {
        this.analyzer.checkState();
        if (e != null) {
            BiConsumer<String, Runnable> runner = Benchmark.instance()::rule;
            this.analyzer.getDataFlow().updateStatus();
            boolean isUnreachable = this.analyzer.getDataFlow().isUnreachable();
            boolean isInFirstIteration = this.analyzer.getDataFlow().isInFirstIteration();
            this.runRules(r -> r.enter(e), runner, isUnreachable, isInFirstIteration);
            int prevSuppressed = this.analyzer.getSuppressed().size();
            int prevAnnotations = this.analyzer.getAnnotations().size();
            this.parseAnnotations(e);
            if (e instanceof CtExecutable) {
                this.analyzer.getAnnotationSetter().processAnnotations((CtExecutable)e);
            }
            super.scan(e);
            this.analyzer.getDataFlow().updateStatus();
            this.runRules(arg_0 -> ((CtElement)e).accept(arg_0), runner, isUnreachable, isInFirstIteration);
            this.analyzer.getSuppressed().subList(prevSuppressed, this.analyzer.getSuppressed().size()).clear();
            this.analyzer.getAnnotations().subList(prevAnnotations, this.analyzer.getAnnotations().size()).clear();
            boolean isUnreachableAfter = this.analyzer.getDataFlow().isUnreachable();
            boolean isInFirstIterationAfter = this.analyzer.getDataFlow().isInFirstIteration();
            this.runRules(r -> r.exit(e), runner, isUnreachableAfter, isInFirstIterationAfter);
        }
    }

    private void parseAnnotations(CtElement e) {
        e.getAnnotations().stream().filter(Objects::nonNull).filter(annotation -> annotation.getType() != null).forEach(this.analyzer.getAnnotations()::add);
        RulesUtils.getSuppressed(e).forEach(this.analyzer.getSuppressed()::add);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> enumElement) {
        this.analyzer.getPrinter().enterType((CtType<?>)enumElement);
        super.visitCtEnum(enumElement);
        this.analyzer.getPrinter().exitType();
    }

    @Override
    public <T> void visitCtClass(CtClass<T> classElement) {
        this.analyzer.getPrinter().enterType((CtType<?>)classElement);
        super.visitCtClass(classElement);
        this.analyzer.getPrinter().exitType();
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> method) {
        long start = System.currentTimeMillis();
        CtElement last = this.analyzer.getLastVisitedElement();
        this.analyzer.setLastVisitedElement((CtElement)method);
        super.visitCtMethod(method);
        this.analyzer.setLastVisitedElement(last);
        String name = method.getDeclaringType().getQualifiedName() + "." + method.getSimpleName();
        Benchmark.instance().function(name, System.currentTimeMillis() - start);
    }
}

