/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.visitors;

import com.pvsstudio.rules.Equality;
import com.pvsstudio.runner.Benchmark;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.support.visitor.equals.EqualsVisitor;

public class PvsStudioEqualsVisitor
extends EqualsVisitor {
    private final Set<Equality> config;

    public PvsStudioEqualsVisitor() {
        this.config = Collections.emptySet();
    }

    public PvsStudioEqualsVisitor(Equality first, Equality ... flags) {
        this.config = EnumSet.of(first, flags);
    }

    private PvsStudioEqualsVisitor(Set<Equality> s) {
        this.config = s;
    }

    private static boolean equals(CtElement a, CtElement b, Set<Equality> s) {
        PvsStudioEqualsVisitor visitor = new PvsStudioEqualsVisitor(s);
        Benchmark.instance().step("Static analysis: equality matching", () -> visitor.biScan(a, b));
        return !visitor.isNotEqual;
    }

    public static boolean equals(CtElement a, CtElement b) {
        PvsStudioEqualsVisitor visitor = new PvsStudioEqualsVisitor();
        Benchmark.instance().step("Static analysis: equality matching", () -> visitor.biScan(a, b));
        return !visitor.isNotEqual;
    }

    public static boolean equals(CtElement a, CtElement b, Equality first, Equality ... flags) {
        PvsStudioEqualsVisitor visitor = new PvsStudioEqualsVisitor(first, flags);
        Benchmark.instance().step("Static analysis: equality matching", () -> visitor.biScan(a, b));
        return !visitor.isNotEqual;
    }

    @Nullable
    private static BinaryOperatorKind inverse(CtBinaryOperator<?> operator) {
        switch (operator.getKind()) {
            case AND: 
            case OR: 
            case EQ: 
            case NE: 
            case MUL: 
            case BITOR: 
            case BITAND: 
            case BITXOR: {
                return operator.getKind();
            }
            case GE: {
                return BinaryOperatorKind.LE;
            }
            case GT: {
                return BinaryOperatorKind.LT;
            }
            case LE: {
                return BinaryOperatorKind.GE;
            }
            case LT: {
                return BinaryOperatorKind.GT;
            }
            case PLUS: {
                return operator.getType() == null || !operator.getType().isPrimitive() ? null : BinaryOperatorKind.PLUS;
            }
        }
        return null;
    }

    protected void biScan(CtRole role, Collection<? extends CtElement> elements, Collection<? extends CtElement> others) {
        if (role == CtRole.CAST && this.config.contains((Object)Equality.IGNORE_CASTS)) {
            return;
        }
        super.biScan(role, elements, others);
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        CtBinaryOperator other = Objects.requireNonNull((CtBinaryOperator)this.stack.peek());
        this.biScan(CtRole.ANNOTATION, operator.getAnnotations(), other.getAnnotations());
        this.biScan((CtElement)operator.getType(), (CtElement)other.getType());
        this.biScan(CtRole.CAST, operator.getTypeCasts(), other.getTypeCasts());
        if (this.isNotEqual) {
            return;
        }
        boolean bl = this.isNotEqual = operator.getKind() != other.getKind() || !PvsStudioEqualsVisitor.equals((CtElement)operator.getLeftHandOperand(), (CtElement)other.getLeftHandOperand(), this.config) || !PvsStudioEqualsVisitor.equals((CtElement)operator.getRightHandOperand(), (CtElement)other.getRightHandOperand(), this.config);
        if (this.isNotEqual && !this.config.contains((Object)Equality.DONT_TRY_COMMUTATIVE_OPERATORS)) {
            this.isNotEqual = PvsStudioEqualsVisitor.inverse(operator) != other.getKind() || !PvsStudioEqualsVisitor.equals((CtElement)operator.getRightHandOperand(), (CtElement)other.getLeftHandOperand(), this.config) || !PvsStudioEqualsVisitor.equals((CtElement)operator.getLeftHandOperand(), (CtElement)other.getRightHandOperand(), this.config);
        }
    }

    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        if (!(this.config.contains((Object)Equality.INC_OR_DEC) || operator.getKind() != UnaryOperatorKind.PREDEC && operator.getKind() != UnaryOperatorKind.POSTINC && operator.getKind() != UnaryOperatorKind.POSTDEC && operator.getKind() != UnaryOperatorKind.PREINC)) {
            this.isNotEqual = true;
            return;
        }
        super.visitCtUnaryOperator(operator);
    }

    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        CtVariableAccess other = Objects.requireNonNull((CtVariableAccess)this.stack.peek());
        this.enter((CtElement)variableRead);
        this.biScan(CtRole.ANNOTATION, variableRead.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, variableRead.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.VARIABLE, (CtElement)variableRead.getVariable(), (CtElement)other.getVariable());
        this.exit((CtElement)variableRead);
    }

    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        CtVariableAccess other = Objects.requireNonNull((CtVariableAccess)this.stack.peek());
        this.enter((CtElement)variableWrite);
        this.biScan(CtRole.ANNOTATION, variableWrite.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, variableWrite.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.VARIABLE, (CtElement)variableWrite.getVariable(), (CtElement)other.getVariable());
        this.exit((CtElement)variableWrite);
    }

    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        CtFieldAccess other = Objects.requireNonNull((CtFieldAccess)this.stack.peek());
        this.enter((CtElement)fieldRead);
        this.biScan(CtRole.ANNOTATION, fieldRead.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, fieldRead.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)fieldRead.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.VARIABLE, (CtElement)fieldRead.getVariable(), (CtElement)other.getVariable());
        this.exit((CtElement)fieldRead);
    }

    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        CtFieldAccess other = Objects.requireNonNull((CtFieldAccess)this.stack.peek());
        this.enter((CtElement)fieldWrite);
        this.biScan(CtRole.ANNOTATION, fieldWrite.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, fieldWrite.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)fieldWrite.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.VARIABLE, (CtElement)fieldWrite.getVariable(), (CtElement)other.getVariable());
        this.exit((CtElement)fieldWrite);
    }

    public <T> void visitCtArrayRead(CtArrayRead<T> field) {
        CtArrayAccess other = Objects.requireNonNull((CtArrayAccess)this.stack.peek());
        this.enter((CtElement)field);
        this.biScan(CtRole.ANNOTATION, field.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, field.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)field.getTarget(), (CtElement)other.getTarget());
        this.biScan((CtElement)field.getIndexExpression(), (CtElement)other.getIndexExpression());
        this.exit((CtElement)field);
    }

    public <T> void visitCtArrayWrite(CtArrayWrite<T> field) {
        CtArrayAccess other = Objects.requireNonNull((CtArrayAccess)this.stack.peek());
        this.enter((CtElement)field);
        this.biScan(CtRole.ANNOTATION, field.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, field.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)field.getTarget(), (CtElement)other.getTarget());
        this.biScan((CtElement)field.getIndexExpression(), (CtElement)other.getIndexExpression());
        this.exit((CtElement)field);
    }
}

