/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.visitors;

import com.pvsstudio.dataflow.VariablesCache;
import com.pvsstudio.runner.Benchmark;
import java.util.IdentityHashMap;
import java.util.Map;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

public final class ModificationsScanner
extends CtScanner {
    private final Map<CtElement, Boolean> result = new IdentityHashMap<CtElement, Boolean>();
    private final VariablesCache vars;

    private ModificationsScanner(VariablesCache vars) {
        this.vars = vars;
    }

    public static Map<CtElement, Boolean> scan(CtElement e, VariablesCache vars) {
        long start = System.currentTimeMillis();
        ModificationsScanner scanner = new ModificationsScanner(vars);
        e.accept((CtVisitor)scanner);
        Benchmark.instance().step("Static analysis: modifications scanner", System.currentTimeMillis() - start);
        return scanner.result;
    }

    public static boolean hasAnyModification(CtElement e, VariablesCache vars) {
        return !ModificationsScanner.scan(e, vars).isEmpty();
    }

    private void modify(CtVariableReference<?> e, boolean onlyState) {
        CtVariable<?> var;
        if (e != null && (var = this.vars.resolve(e)) != null) {
            this.result.put((CtElement)var, onlyState);
        }
    }

    private void modify(CtExpression<?> e, boolean onlyState) {
        if (e instanceof CtArrayAccess) {
            this.result.put((CtElement)e, onlyState);
            this.modify(((CtArrayAccess)e).getTarget(), true);
        } else if (e instanceof CtThisAccess) {
            this.result.put((CtElement)e, true);
        } else if (e instanceof CtFieldAccess) {
            this.result.put((CtElement)e, onlyState);
            this.modify((CtVariableReference<?>)((CtFieldAccess)e).getVariable(), onlyState);
        } else if (e instanceof CtVariableAccess) {
            this.result.put((CtElement)e, onlyState);
            this.modify(((CtVariableAccess)e).getVariable(), onlyState);
        }
    }

    public <T> void visitCtReturn(CtReturn<T> st) {
        this.modify(st.getReturnedExpression(), true);
        super.visitCtReturn(st);
    }

    private <T> void visitAbstractInvocation(CtAbstractInvocation<T> st) {
        if (st instanceof CtTargetedExpression) {
            this.modify(((CtTargetedExpression)st).getTarget(), true);
        }
        for (CtExpression arg : st.getArguments()) {
            if (arg.getType() != null && arg.getType().isPrimitive()) continue;
            this.modify(arg, true);
        }
    }

    public <T> void visitCtInvocation(CtInvocation<T> st) {
        this.visitAbstractInvocation((CtAbstractInvocation<T>)st);
        super.visitCtInvocation(st);
    }

    public <T> void visitCtNewClass(CtNewClass<T> st) {
        this.visitAbstractInvocation((CtAbstractInvocation<T>)st);
        super.visitCtNewClass(st);
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> st) {
        this.visitAbstractInvocation((CtAbstractInvocation<T>)st);
        super.visitCtConstructorCall(st);
    }

    public <T> void visitCtArrayWrite(CtArrayWrite<T> st) {
        this.modify((CtExpression<?>)st, true);
        super.visitCtArrayWrite(st);
    }

    public <T> void visitCtVariableWrite(CtVariableWrite<T> st) {
        this.modify((CtExpression<?>)st, false);
        super.visitCtVariableWrite(st);
    }

    public <T> void visitCtFieldWrite(CtFieldWrite<T> st) {
        this.modify((CtExpression<?>)st, false);
        super.visitCtFieldWrite(st);
    }
}

