/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.visitors;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.AstVisitor;
import com.pvsstudio.core.BinaryOperator;
import com.pvsstudio.core.CatchBodyVisitor;
import com.pvsstudio.core.FirstIterationVisitor;
import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.core.LogicOperator;
import com.pvsstudio.core.LoopVisitor;
import com.pvsstudio.core.NegateConditionVisitor;
import com.pvsstudio.core.OptionalInt;
import com.pvsstudio.core.SwitchVisitor;
import com.pvsstudio.core.TryBodyVisitor;
import com.pvsstudio.core.TryVisitor;
import com.pvsstudio.core.Type;
import com.pvsstudio.core.TypeClassification;
import com.pvsstudio.core.TypeInformation;
import com.pvsstudio.core.UnaryOperator;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.ValueBuilder;
import com.pvsstudio.core.Variable;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.dataflow.IntConstantsPool;
import com.pvsstudio.dataflow.MethodAnnotation;
import com.pvsstudio.dataflow.resolvers.ParseIntResolver;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.visitors.ConditionVisitor;
import com.pvsstudio.visitors.LoopContinueVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CaseKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class DataFlowVisitor
extends CtScanner {
    private final DataFlow dataFlow;

    public DataFlowVisitor(@NotNull DataFlow dataFlow) {
        this.dataFlow = dataFlow;
    }

    public void scan(CtElement e) {
        super.scan(e);
        this.dataFlow.mergeBreak(e);
    }

    public void scan(Collection<? extends CtElement> elements) {
        if (elements != null) {
            for (CtElement ctElement : elements) {
                this.scan(ctElement);
            }
        }
    }

    public void scan(CtRole role, Collection<? extends CtElement> elements) {
        this.scan(elements);
    }

    public <T> void visitCtField(CtField<T> field) {
        if (!this.dataFlow.hasImmutableValue((CtVariableReference<?>)field.getReference())) {
            super.visitCtField(field);
            this.dataFlow.visitRead((CtElement)field.getAssignment());
            return;
        }
        if (field.getAssignment() != null) {
            boolean keepState = this.dataFlow.hasImmutableState((CtVariableReference<?>)field.getReference());
            this.dataFlow.setValue((CtElement)field, this.dataFlow.visitVariableReference((CtVariable<?>)field));
            this.visitAssign((CtTypedElement<?>)field, (CtExpression<?>)field.getAssignment(), keepState);
            if (!keepState) {
                this.deleteValue((CtElement)field, true);
            }
        }
    }

    public <T> void visitCtClass(CtClass<T> classElement) {
        this.dataFlow.visitClass(classElement, this);
    }

    public <T> void visitCtInterface(CtInterface<T> ctInterface) {
        this.dataFlow.visitClass(ctInterface, this);
    }

    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> enumElement) {
        this.dataFlow.visitClass(enumElement, this);
    }

    public <T> void visitCtMethod(CtMethod<T> method) {
        this.dataFlow.visitMethod(method, x$0 -> super.visitCtMethod(x$0));
    }

    public void visitCtAnonymousExecutable(CtAnonymousExecutable method) {
        this.dataFlow.visitMethod(method, x$0 -> super.visitCtAnonymousExecutable(x$0));
    }

    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.dataFlow.visitMethod(lambda, x$0 -> super.visitCtLambda(x$0));
    }

    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> methodReference) {
        super.visitCtExecutableReferenceExpression(methodReference);
        this.dataFlow.visitRead((CtElement)methodReference.getTarget());
        Variable variable = this.dataFlow.getValue((CtElement)methodReference.getTarget()).getVariable();
        if (variable != null) {
            MethodAnnotation res = this.dataFlow.setMethodAnnotation(methodReference);
            if (res != null) {
                Value value;
                if (methodReference.getParent() instanceof CtInvocation && (value = this.dataFlow.visitFunctionCall(res.getContext(), res.getAnnotation())).toInteger() != null) {
                    this.dataFlow.setValue(methodReference, value);
                }
                if (res.getAnnotation().is(FunctionClassification.ModifiesObject)) {
                    this.deleteValue((CtElement)methodReference.getTarget(), true);
                }
                if (res.getAnnotation().is(FunctionClassification.NoReturn)) {
                    this.checkFirstStatementForNoReturn((CtElement)methodReference);
                    this.dataFlow.visitUnreachable();
                }
            } else {
                this.dataFlow.visitImpure();
            }
            if (res == null || res.getAnnotation().is(FunctionClassification.ModifiesObject)) {
                this.dataFlow.addGlobalVariable(variable, true);
            }
        }
    }

    public <T> void visitCtConstructor(CtConstructor<T> method) {
        this.dataFlow.visitMethod(method, x$0 -> super.visitCtConstructor(x$0));
    }

    private ConditionVisitor conditionVisitor(CtCodeElement e) {
        return new ConditionVisitor(this, e, this.dataFlow, true);
    }

    private ConditionVisitor branchVisitor(CtCodeElement e) {
        return new ConditionVisitor(this, e, this.dataFlow, false);
    }

    private static boolean isLogicOperator(@Nullable CtCodeElement e) {
        if (e instanceof CtBinaryOperator) {
            CtBinaryOperator o = (CtBinaryOperator)e;
            return o.getKind() == BinaryOperatorKind.AND || o.getKind() == BinaryOperatorKind.OR;
        }
        if (e instanceof CtUnaryOperator) {
            CtUnaryOperator o = (CtUnaryOperator)e;
            return o.getKind() == UnaryOperatorKind.NOT && DataFlowVisitor.isLogicOperator((CtCodeElement)o.getOperand());
        }
        return false;
    }

    public void visitCtIf(CtIf statement) {
        this.dataFlow.visitCondition(DataFlowVisitor.isLogicOperator((CtCodeElement)statement.getCondition()), this.dataFlow.getExpressionIndex((CtElement)statement.getCondition()), this.conditionVisitor((CtCodeElement)statement.getCondition()), this.branchVisitor((CtCodeElement)statement.getThenStatement()), this.branchVisitor((CtCodeElement)statement.getElseStatement()));
    }

    public <T> void visitCtConditional(CtConditional<T> expression) {
        this.dataFlow.setValue(expression, this.dataFlow.visitTernaryCondition(RulesUtils.getTypeName(expression), RulesUtils.getTypeName(expression.getThenExpression()), RulesUtils.getTypeName(expression.getElseExpression()), DataFlowVisitor.isLogicOperator((CtCodeElement)expression.getCondition()), this.dataFlow.getExpressionIndex((CtElement)expression.getCondition()), this.conditionVisitor((CtCodeElement)expression.getCondition()), this.branchVisitor((CtCodeElement)expression.getThenExpression()), this.branchVisitor((CtCodeElement)expression.getElseExpression())));
    }

    public <T> void visitCtThisAccess(CtThisAccess<T> var) {
        this.dataFlow.setValue(var, this.dataFlow.visitThisReference((CtTargetedExpression<?, ?>)var));
    }

    public <T> void visitCtSuperAccess(CtSuperAccess<T> var) {
        this.dataFlow.setValue(var, this.dataFlow.visitThisReference((CtTargetedExpression<?, ?>)var));
    }

    private Value visitAssign(@NotNull CtTypedElement<?> lhs, @NotNull CtExpression<?> rhs, boolean assignArrays) {
        CtTypeReference type;
        Value lhsValue = this.dataFlow.getValue((CtElement)lhs);
        Value res = this.dataFlow.visitAssign(RulesUtils.getRawTypeName(lhs), RulesUtils.getTypeName(rhs), lhsValue, DataFlowVisitor.isLogicOperator(rhs), this.dataFlow.getExpressionIndex((CtElement)rhs), this.branchVisitor((CtCodeElement)rhs));
        Variable var = lhsValue.getVariable();
        if (assignArrays && var != null && rhs instanceof CtNewArray && (type = lhs.getType()) instanceof CtArrayTypeReference) {
            String arrayType = RulesUtils.getTypeName(((CtArrayTypeReference)type).getArrayType());
            CtNewArray array = (CtNewArray)rhs;
            int i = 0;
            for (final CtExpression element : array.getElements()) {
                this.dataFlow.visitAssign(arrayType, RulesUtils.getTypeName(element), this.dataFlow.visitVariableFieldReference(arrayType, var, i), false, this.dataFlow.getExpressionIndex((CtElement)element), new AstVisitor(){

                    @Override
                    public Value visit() {
                        return DataFlowVisitor.this.dataFlow.getValue((CtElement)element);
                    }
                });
                ++i;
            }
        }
        return res;
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.dataFlow.setValue((CtElement)localVariable, this.dataFlow.visitVariableReference((CtVariable<?>)localVariable));
        if (localVariable.getAssignment() != null) {
            this.visitAssign((CtTypedElement<?>)localVariable, (CtExpression<?>)localVariable.getAssignment(), true);
            if (RulesUtils.isPrimitive(localVariable)) {
                this.dataFlow.visitDereference((CtTypedElement<?>)localVariable.getAssignment());
            }
        }
    }

    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.dataFlow.setValue(variableRead, this.dataFlow.visitVariableReference((CtVariableAccess<?>)variableRead));
    }

    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.dataFlow.setValue(variableWrite, this.dataFlow.visitVariableReference((CtVariableAccess<?>)variableWrite));
    }

    public <T> void visitCtFieldRead(CtFieldRead<T> variable) {
        this.scan((CtElement)variable.getTarget());
        Pair<Number, Type> fromIntPool = IntConstantsPool.getFromPool(variable);
        if (fromIntPool != null) {
            this.dataFlow.setValue(variable, this.dataFlow.visitIntegerLiteral(((Number)fromIntPool.getLeft()).longValue(), (Type)((Object)fromIntPool.getRight())));
            return;
        }
        this.dataFlow.setValue(variable, this.dataFlow.visitVariableReference((CtFieldAccess<?>)variable));
        this.dataFlow.visitDereference((CtTypedElement<?>)variable.getTarget());
    }

    public <T> void visitCtFieldWrite(CtFieldWrite<T> variable) {
        this.scan((CtElement)variable.getTarget());
        this.dataFlow.setValue(variable, this.dataFlow.visitVariableReference((CtFieldAccess<?>)variable));
        this.dataFlow.visitDereference((CtTypedElement<?>)variable.getTarget());
    }

    public <T> void visitCtTypeReference(CtTypeReference<T> ref) {
    }

    public <T> void visitCtArrayRead(CtArrayRead<T> array) {
        this.scan((CtElement)array.getTarget());
        this.scan((CtElement)array.getIndexExpression());
        this.dataFlow.setValue(array, this.dataFlow.visitArray(RulesUtils.getTypeName(array), this.dataFlow.getValue((CtElement)array.getTarget()), this.dataFlow.getValue((CtElement)array.getIndexExpression())));
    }

    public <T> void visitCtArrayWrite(CtArrayWrite<T> array) {
        this.scan((CtElement)array.getTarget());
        this.scan((CtElement)array.getIndexExpression());
        this.dataFlow.setValue(array, this.dataFlow.visitArray(RulesUtils.getTypeName(array), this.dataFlow.getValue((CtElement)array.getTarget()), this.dataFlow.getValue((CtElement)array.getIndexExpression())));
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() == BinaryOperatorKind.AND || operator.getKind() == BinaryOperatorKind.OR) {
            this.dataFlow.visitShortCircuit(DataFlowVisitor.isLogicOperator((CtCodeElement)operator.getLeftHandOperand()), DataFlowVisitor.isLogicOperator((CtCodeElement)operator.getRightHandOperand()), this.dataFlow.getExpressionIndex((CtElement)operator.getLeftHandOperand()), operator.getKind() == BinaryOperatorKind.AND ? LogicOperator.And : LogicOperator.Or, this.conditionVisitor((CtCodeElement)operator.getLeftHandOperand()), this.conditionVisitor((CtCodeElement)operator.getRightHandOperand()));
        } else {
            super.visitCtBinaryOperator(operator);
        }
        BinaryOperator op = DataFlow.getBinaryOperator(operator.getKind());
        CtExpression lhs = operator.getLeftHandOperand();
        CtExpression rhs = operator.getRightHandOperand();
        if (op != null) {
            this.dataFlow.setValue(operator, this.dataFlow.visitBinaryOperation(RulesUtils.getRawTypeName(operator), op, this.dataFlow.getValue((CtElement)lhs), RulesUtils.getTypeName(lhs), this.dataFlow.getValue((CtElement)rhs), RulesUtils.getTypeName(rhs)));
            if (operator.getKind() != BinaryOperatorKind.INSTANCEOF && operator.getKind() != BinaryOperatorKind.AND && operator.getKind() != BinaryOperatorKind.OR && (RulesUtils.isPrimitive(operator.getLeftHandOperand()) || RulesUtils.isPrimitive(operator.getRightHandOperand())) && !this.dataFlow.getSafeTypeAnnotation(operator.getLeftHandOperand()).is(TypeClassification.String) && !this.dataFlow.getSafeTypeAnnotation(operator.getRightHandOperand()).is(TypeClassification.String)) {
                this.dataFlow.visitDereference((CtTypedElement<?>)operator.getLeftHandOperand());
                this.dataFlow.visitDereference((CtTypedElement<?>)operator.getRightHandOperand());
            }
        } else {
            this.dataFlow.visitRead((CtElement)lhs);
            this.dataFlow.visitRead((CtElement)rhs);
        }
    }

    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        Value res = Value.EMPTY;
        Object value = literal.getValue();
        if (value == null) {
            res = this.dataFlow.visitNull();
        } else if (value instanceof Boolean) {
            res = this.dataFlow.visitBooleanLiteral((Boolean)value);
        } else if (value instanceof Byte) {
            res = this.dataFlow.visitIntegerLiteral(((Byte)value).byteValue(), Type.Int8);
        } else if (value instanceof Short) {
            res = this.dataFlow.visitIntegerLiteral(((Short)value).shortValue(), Type.Int16);
        } else if (value instanceof Integer) {
            res = this.dataFlow.visitIntegerLiteral(((Integer)value).intValue(), Type.Int32);
        } else if (value instanceof Long) {
            res = this.dataFlow.visitIntegerLiteral((Long)value, Type.Int64);
        } else if (value instanceof Character) {
            res = this.dataFlow.visitIntegerLiteral(((Character)value).charValue(), Type.Uint16);
        } else if (value instanceof String) {
            res = this.dataFlow.visitStringLiteral((String)value, 2L);
        }
        this.dataFlow.setValue(literal, res);
    }

    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        try (NegateConditionVisitor conditionVisitor = operator.getKind() == UnaryOperatorKind.NOT ? new NegateConditionVisitor(this.dataFlow) : null;){
            super.visitCtUnaryOperator(operator);
            UnaryOperator op = DataFlow.getUnaryOperator(operator.getKind());
            this.dataFlow.setValue(operator, this.dataFlow.visitUnaryOperation(RulesUtils.getTypeName(operator), RulesUtils.getTypeName(operator.getOperand()), op, this.dataFlow.getValue((CtElement)operator.getOperand()), operator.getKind() == UnaryOperatorKind.POSTINC || operator.getKind() == UnaryOperatorKind.POSTDEC));
            this.dataFlow.visitDereference((CtTypedElement<?>)operator.getOperand());
        }
    }

    private boolean isParameter(CtExpression<?> e) {
        if (e instanceof CtFieldAccess) {
            return this.isParameter(((CtFieldAccess)e).getTarget());
        }
        if (e instanceof CtVariableAccess) {
            return ((CtVariableAccess)e).getVariable() instanceof CtParameterReference;
        }
        if (e instanceof CtArrayAccess) {
            return this.isParameter(((CtArrayAccess)e).getTarget());
        }
        return false;
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        super.visitCtOperatorAssignment(assignment);
        BinaryOperator op = DataFlow.getBinaryOperator(assignment.getKind());
        if (op != null) {
            CtExpression lhs = assignment.getAssigned();
            CtExpression rhs = assignment.getAssignment();
            this.dataFlow.setValue(assignment, this.dataFlow.visitBinaryAssignmentOperation(RulesUtils.getTypeName(assignment), op, this.dataFlow.getValue((CtElement)lhs), RulesUtils.getTypeName(lhs), this.dataFlow.getValue((CtElement)rhs), RulesUtils.getTypeName(rhs), this.dataFlow.getExpressionIndex((CtElement)rhs)));
        }
        if (this.isParameter(assignment.getAssignment())) {
            this.dataFlow.visitImpure();
        }
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        this.scan((CtElement)assignment.getAssigned());
        this.dataFlow.setValue(assignment, this.visitAssign((CtTypedElement<?>)assignment.getAssigned(), (CtExpression<?>)assignment.getAssignment(), true));
        if (this.isParameter(assignment.getAssignment()) || this.isParameter(assignment.getAssigned())) {
            this.dataFlow.visitImpure();
        }
    }

    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        super.visitCtReturn(returnStatement);
        if (returnStatement.getReturnedExpression() == null) {
            this.dataFlow.visitReturn(Value.EMPTY);
        } else {
            CtExecutable<?> method = this.dataFlow.getCurrentMethod();
            CtTypeReference type = method == null ? null : method.getType();
            this.dataFlow.visitReturn(this.dataFlow.cast(this.dataFlow.getValue((CtElement)returnStatement.getReturnedExpression()), RulesUtils.getTypeName(returnStatement.getReturnedExpression()), RulesUtils.getTypeName(type)));
        }
        this.dataFlow.visitGlobalsRead();
    }

    public void visitCtBreak(CtBreak breakStatement) {
        super.visitCtBreak(breakStatement);
        this.dataFlow.visitBreak(breakStatement);
    }

    public void visitCtContinue(CtContinue continueStatement) {
        super.visitCtContinue(continueStatement);
        this.dataFlow.visitContinue(continueStatement);
    }

    private void checkFirstStatementForNoReturn(CtElement other) {
        CtExecutable<?> currentMethod = this.dataFlow.getCurrentMethod();
        if (currentMethod != null && currentMethod.getBody() != null && !currentMethod.getBody().getStatements().isEmpty() && currentMethod.getBody().getStatements().get(0) == other) {
            this.dataFlow.visitNoReturn();
        }
    }

    public void visitCtThrow(CtThrow throwStatement) {
        super.visitCtThrow(throwStatement);
        this.checkFirstStatementForNoReturn((CtElement)throwStatement);
        this.dataFlow.visitUnreachable();
        this.dataFlow.visitRead((CtElement)throwStatement.getThrownExpression());
        this.dataFlow.visitGlobalsRead();
    }

    private void visitLoop(Runnable visitor) {
        try (FirstIterationVisitor firstIterationVisitor = new FirstIterationVisitor(this.dataFlow);){
            visitor.run();
        }
        try (LoopVisitor loopVisitor = new LoopVisitor(this.dataFlow);){
            visitor.run();
        }
    }

    private void visitPreconditionLoop(CtLoop loop, CtExpression<?> condition, List<CtStatement> postAction) {
        try (LoopContinueVisitor visitor = new LoopContinueVisitor(this.dataFlow, loop);){
            if (condition == null) {
                this.dataFlow.visitTrueLoopCondition();
            } else {
                this.dataFlow.visitLoopCondition(DataFlowVisitor.isLogicOperator(condition), this.conditionVisitor((CtCodeElement)condition));
            }
            if (postAction != null) {
                for (CtStatement stmt : postAction) {
                    CtExpression lhs;
                    if (!(stmt instanceof CtAssignment) || !RulesUtils.isIntegerType(lhs = ((CtAssignment)stmt).getAssigned())) continue;
                    this.deleteValue((CtElement)lhs, false);
                }
            }
            this.scan((CtElement)loop.getBody());
        }
        this.scan(postAction);
    }

    private void visitForEach(CtForEach loop) {
        try (LoopContinueVisitor visitor = new LoopContinueVisitor(this.dataFlow, (CtLoop)loop);){
            this.dataFlow.visitEmptyLoopCondition();
            this.dataFlow.visitRead((CtElement)loop.getExpression());
            this.scan((CtElement)loop.getExpression());
            this.scan((CtElement)loop.getVariable());
            this.scan((CtElement)loop.getBody());
        }
    }

    private void visitPostConditionLoop(CtDo doStatement) {
        try (LoopContinueVisitor visitor = new LoopContinueVisitor(this.dataFlow, (CtLoop)doStatement);){
            this.scan((CtElement)doStatement.getBody());
        }
        CtExpression condition = doStatement.getLoopingExpression();
        this.dataFlow.visitLoopPostCondition(DataFlowVisitor.isLogicOperator((CtCodeElement)condition), this.conditionVisitor((CtCodeElement)condition), RulesUtils.isFalseLiteral(condition));
    }

    public void visitCtFor(CtFor forStatement) {
        this.scan(forStatement.getForInit());
        this.visitLoop(() -> this.visitPreconditionLoop((CtLoop)forStatement, forStatement.getExpression(), forStatement.getForUpdate()));
    }

    public void visitCtWhile(CtWhile whileStatement) {
        this.visitLoop(() -> this.visitPreconditionLoop((CtLoop)whileStatement, whileStatement.getLoopingExpression(), null));
    }

    public void visitCtDo(CtDo doStatement) {
        this.visitLoop(() -> this.visitPostConditionLoop(doStatement));
    }

    public void visitCtForEach(CtForEach forStatement) {
        this.visitLoop(() -> this.visitForEach(forStatement));
    }

    public void deleteValue(CtTypedElement<?> e) {
        this.deleteValue((CtElement)e, false);
    }

    public void deleteValue(CtElement e, boolean onlyState) {
        this.dataFlow.deleteValue(this.dataFlow.getValue(e), onlyState);
    }

    private <T> void visitAbstractInvocation(CtAbstractInvocation<T> inv) {
        MethodAnnotation annotation;
        for (CtElement arg : inv.getArguments()) {
            this.dataFlow.visitRead(arg);
        }
        if (inv.getExecutable() != null && inv.getExecutable().getDeclaringType() != null && inv.getExecutable().getDeclaringType().getQualifiedName().equals("java.lang.Integer") && inv.getExecutable().getSimpleName().equals("parseInt") && inv.getArguments().size() == 1) {
            new ParseIntResolver(this.dataFlow).resolve((CtElement)inv);
        }
        if ((annotation = this.dataFlow.setMethodAnnotation(inv)) != null) {
            if (inv instanceof CtExpression) {
                this.dataFlow.setValue((CtExpression)inv, annotation.getValue());
            }
            if (annotation.getAnnotation().is(FunctionClassification.NoReturn)) {
                this.checkFirstStatementForNoReturn((CtElement)inv);
                this.dataFlow.visitUnreachable();
            }
        } else {
            this.dataFlow.visitImpure();
        }
        if (annotation == null || annotation.getAnnotation().interproceduralInformation() != 0L) {
            this.dataFlow.removeGlobalVariables();
            if (!inv.getExecutable().isStatic() && inv instanceof CtInvocation) {
                CtExpression target = ((CtInvocation)inv).getTarget();
                if (target instanceof CtThisAccess) {
                    this.dataFlow.removeThisValue();
                } else {
                    Annotation argAnnotation = this.dataFlow.getTypeAnnotation(target);
                    if (argAnnotation == null || !argAnnotation.is(TypeClassification.Immutable)) {
                        this.deleteValue((CtElement)target, true);
                    }
                }
            }
            for (CtExpression arg : inv.getArguments()) {
                Annotation argAnnotation;
                if (RulesUtils.isPrimitive(arg) || (argAnnotation = this.dataFlow.getTypeAnnotation(arg)) != null && argAnnotation.is(TypeClassification.Immutable)) continue;
                this.deleteValue((CtElement)arg, true);
            }
        }
    }

    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        super.visitCtInvocation(inv);
        this.dataFlow.visitRead((CtElement)inv.getTarget());
        this.visitAbstractInvocation((CtAbstractInvocation<T>)inv);
        this.dataFlow.visitDereference((CtTypedElement<?>)inv.getTarget());
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> constructor) {
        CtClass anonymousClass;
        this.dataFlow.visitImpure();
        super.visitCtConstructorCall(constructor);
        this.dataFlow.visitRead((CtElement)constructor.getTarget());
        this.visitAbstractInvocation((CtAbstractInvocation<T>)constructor);
        Value result = this.dataFlow.getValue((CtElement)constructor);
        long expressionIndex = this.dataFlow.getExpressionIndex((CtElement)constructor);
        if (constructor instanceof CtNewClass && !(anonymousClass = ((CtNewClass)constructor).getAnonymousClass()).getAnonymousExecutables().isEmpty()) {
            this.dataFlow.setValue(constructor, Value.EMPTY);
            return;
        }
        this.dataFlow.setValue(constructor, new ValueBuilder(this.dataFlow.getPool(), result).setValue(this.dataFlow.getNewReference(result, expressionIndex)).build());
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        super.visitCtBlock(block);
        if (block.getParent() == this.dataFlow.getCurrentMethod()) {
            this.dataFlow.visitGlobalsRead();
            this.dataFlow.visitReturn(Value.EMPTY);
        }
    }

    public <T> void visitCtNewClass(CtNewClass<T> constructor) {
        this.dataFlow.visitImpure();
        this.dataFlow.getTypesCache().add((CtType<?>)constructor.getAnonymousClass());
        this.scan((CtElement)constructor.getAnonymousClass());
        this.visitCtConstructorCall((CtConstructorCall<T>)constructor);
    }

    public <T> void visitCtNewArray(CtNewArray<T> array) {
        this.dataFlow.visitImpure();
        super.visitCtNewArray(array);
        int count = 0;
        array.getDimensionExpressions().forEach(this.dataFlow::visitRead);
        if (array.getDimensionExpressions().isEmpty()) {
            count = array.getElements().size();
        } else {
            CtExpression dimension = (CtExpression)array.getDimensionExpressions().get(0);
            OptionalInt o = this.dataFlow.getValue((CtElement)dimension).toInt();
            if (o.isPresent()) {
                count = o.get();
            }
        }
        array.getElements().forEach(this.dataFlow::visitRead);
        this.dataFlow.setValue(array, this.dataFlow.visitUnknownValue(this.dataFlow.getNewReference(Value.EMPTY, this.dataFlow.getExpressionIndex((CtElement)array), count)));
    }

    public void visitCtCatch(CtCatch catchStatement) {
        try (CatchBodyVisitor visitor = new CatchBodyVisitor(this.dataFlow);){
            this.scan((CtElement)catchStatement.getBody());
        }
    }

    public void visitCtTry(CtTry tryStatement) {
        boolean isUnreachable = this.dataFlow.isUnreachable();
        try (TryVisitor tryVisitor = new TryVisitor(this.dataFlow);){
            try (TryBodyVisitor visitor = new TryBodyVisitor(this.dataFlow);){
                this.scan((CtElement)tryStatement.getBody());
            }
            this.scan(tryStatement.getCatchers());
        }
        this.dataFlow.updateStatus();
        if (!isUnreachable && this.dataFlow.isUnreachable()) {
            this.dataFlow.visitReachable();
            this.scan((CtElement)tryStatement.getFinalizer());
            this.dataFlow.visitUnreachable();
        } else {
            this.scan((CtElement)tryStatement.getFinalizer());
        }
    }

    public void visitCtTryWithResource(CtTryWithResource tryStatement) {
        this.scan(tryStatement.getResources());
        this.visitCtTry((CtTry)tryStatement);
    }

    public <T> void visitCtSwitch(CtSwitch<T> switchStatement) {
        this.visitAbstractSwitch((CtAbstractSwitch<?>)switchStatement);
    }

    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
        this.visitAbstractSwitch((CtAbstractSwitch<?>)switchExpression);
    }

    private void visitAbstractSwitch(CtAbstractSwitch<?> abstractSwitch) {
        CtTypeReference unboxed;
        CtExpression selector = abstractSwitch.getSelector();
        this.scan((CtElement)selector);
        this.dataFlow.visitDereference((CtTypedElement<?>)selector);
        this.dataFlow.visitRead((CtElement)selector);
        Value selectorValue = this.dataFlow.getValue((CtElement)selector);
        CtTypeReference<?> selectorType = RulesUtils.getType(selector);
        TypeInformation variableType = this.dataFlow.getType(RulesUtils.getTypeName(selectorType));
        if (selectorType != null && !selectorType.isPrimitive() && (unboxed = selectorType.unbox()) != null && unboxed.isPrimitive()) {
            selectorValue = this.dataFlow.cast(selectorValue, selectorType.getQualifiedName(), unboxed.getQualifiedName());
            variableType = this.dataFlow.getType(RulesUtils.getTypeName(unboxed));
        }
        try (SwitchVisitor visitor = new SwitchVisitor(this.dataFlow, selectorValue, variableType);){
            this.scan(abstractSwitch.getCases());
        }
    }

    private void calcDefaultValue(CtCase<?> caseStatement) {
        CtSwitch currentSwitch = (CtSwitch)caseStatement.getParent((Filter)new TypeFilter(CtSwitch.class));
        if (currentSwitch == null) {
            return;
        }
        currentSwitch.getCases().stream().map(CtCase::getCaseExpression).filter(Objects::nonNull).forEach(exp -> this.dataFlow.visitCaseValue(this.dataFlow.getValue((CtElement)exp), RulesUtils.getTypeName(exp)));
    }

    public <T> void visitCtCase(CtCase<T> caseStatement) {
        CtExpression e = caseStatement.getCaseExpression();
        if (e != null && this.dataFlow.isUnreachable() && !this.dataFlow.currentSwitch().getUnreachable()) {
            this.dataFlow.visitReachable();
            this.scan((CtElement)e);
            this.dataFlow.visitUnreachable();
        } else {
            this.scan((CtElement)e);
        }
        if (RulesUtils.isDefault(caseStatement)) {
            this.dataFlow.clearCaseValues();
            this.calcDefaultValue(caseStatement);
            this.dataFlow.visitDefault();
        } else {
            this.dataFlow.visitCase(this.dataFlow.getValue((CtElement)e), RulesUtils.getTypeName(e));
        }
        this.scan(caseStatement.getStatements());
        if (caseStatement.getCaseKind() == CaseKind.ARROW) {
            this.dataFlow.visitBreak();
        }
    }

    public void visitCtSynchronized(CtSynchronized block) {
        this.dataFlow.removeGlobalVariables();
        this.dataFlow.removeThisValue();
        super.visitCtSynchronized(block);
        this.dataFlow.visitRead((CtElement)block.getExpression());
    }

    public <T> void visitCtAssert(final CtAssert<T> asserted) {
        CtExpression expression = asserted.getAssertExpression();
        this.dataFlow.visitCondition(DataFlowVisitor.isLogicOperator((CtCodeElement)expression), this.dataFlow.getExpressionIndex((CtElement)expression), this.conditionVisitor((CtCodeElement)expression), this.branchVisitor(null), new AstVisitor(){

            @Override
            public Value visit() {
                Value value = DataFlowVisitor.this.branchVisitor((CtCodeElement)asserted.getExpression()).visit();
                DataFlowVisitor.this.dataFlow.visitUnreachable();
                return value;
            }
        });
        this.dataFlow.visitRead((CtElement)expression);
    }
}

