/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.visitors;

import com.google.common.base.Equivalence;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.pvsstudio.dataflow.DataFlow;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.CtScanner;

public class CallGraphVisitor
extends CtScanner {
    private static final Logger logger = LoggerFactory.getLogger(CallGraphVisitor.class);
    private final MutableGraph<CtElement> callGraph;
    private CtElement currentExecutable = null;
    private final List<CtElement> sorted = new ArrayList<CtElement>();
    private final List<CtElement> endNodes = new ArrayList<CtElement>();
    private final Set<Equivalence.Wrapper<? extends CtElement>> membersToSort = new LinkedHashSet<Equivalence.Wrapper<? extends CtElement>>();
    private final Set<Equivalence.Wrapper<? extends CtElement>> externalMembers = new LinkedHashSet<Equivalence.Wrapper<? extends CtElement>>();

    public CallGraphVisitor() {
        this.callGraph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
    }

    private <T extends CtElement> void visitElement(T e, Consumer<T> fn) {
        CtElement oldMethod = this.currentExecutable;
        this.currentExecutable = e;
        if (oldMethod != null) {
            this.callGraph.putEdge((Object)oldMethod, e);
        } else {
            this.callGraph.addNode(e);
        }
        fn.accept(e);
        this.currentExecutable = oldMethod;
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.visitElement(ctClass, x$0 -> super.visitCtClass(x$0));
    }

    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.visitElement(ctEnum, x$0 -> super.visitCtEnum(x$0));
    }

    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.visitElement(intrface, x$0 -> super.visitCtInterface(x$0));
    }

    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.visitElement(c, x$0 -> super.visitCtConstructor(x$0));
    }

    public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
        this.visitElement(anonymousExec, x$0 -> super.visitCtAnonymousExecutable(x$0));
    }

    public <T> void visitCtMethod(CtMethod<T> m) {
        this.visitElement(m, x$0 -> super.visitCtMethod(x$0));
    }

    public <T> void visitCtField(CtField<T> f) {
        this.visitElement(f, x$0 -> super.visitCtField(x$0));
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        if (this.currentExecutable == null) {
            return;
        }
        this.visitInvocation((CtAbstractInvocation<T>)ctConstructorCall);
        super.visitCtConstructorCall(ctConstructorCall);
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (this.currentExecutable == null) {
            return;
        }
        this.visitInvocation((CtAbstractInvocation<T>)invocation);
        super.visitCtInvocation(invocation);
    }

    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        if (this.currentExecutable == null) {
            return;
        }
        this.visitVariable((CtVariableAccess<T>)variableRead);
        super.visitCtVariableRead(variableRead);
    }

    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        if (this.currentExecutable == null) {
            return;
        }
        this.visitVariable((CtVariableAccess<T>)variableWrite);
        super.visitCtVariableWrite(variableWrite);
    }

    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        if (this.currentExecutable == null) {
            return;
        }
        this.visitVariable((CtVariableAccess<T>)fieldRead);
        super.visitCtFieldRead(fieldRead);
    }

    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        if (this.currentExecutable == null) {
            return;
        }
        this.visitVariable((CtVariableAccess<T>)fieldWrite);
        super.visitCtFieldWrite(fieldWrite);
    }

    private Equivalence.Wrapper<? extends CtElement> wrap(CtElement e) {
        return Equivalence.identity().wrap((Object)e);
    }

    private <T> void visitInvocation(CtAbstractInvocation<T> invocation) {
        try {
            CtExecutable declaration = invocation.getExecutable().getDeclaration();
            if (declaration != null && declaration != this.currentExecutable) {
                this.callGraph.putEdge((Object)declaration, (Object)this.currentExecutable);
                if (!this.membersToSort.contains(this.wrap((CtElement)declaration)) && DataFlow.canUseInterproceduralAnalysis(declaration)) {
                    this.externalMembers.add(this.wrap((CtElement)declaration));
                }
            }
        }
        catch (Exception e) {
            logger.warn("Some exception in " + ((Object)((Object)this)).getClass().getName() + " in private method visitInvocation", (Throwable)e);
        }
    }

    private <T> void visitVariable(CtVariableAccess<T> variableRead) {
        try {
            CtVariable declaration = variableRead.getVariable().getDeclaration();
            if (declaration instanceof CtField && declaration != this.currentExecutable) {
                this.callGraph.putEdge((Object)declaration, (Object)this.currentExecutable);
                if (!this.membersToSort.contains(this.wrap((CtElement)declaration)) && DataFlow.canUseInterproceduralAnalysis((CtField)declaration)) {
                    this.externalMembers.add(this.wrap((CtElement)declaration));
                }
            }
        }
        catch (Exception e) {
            logger.warn("Some exception in " + ((Object)((Object)this)).getClass().getName() + " in private method visitVariable", (Throwable)e);
        }
    }

    public void build(@NotNull Stream<? extends CtElement> elements) {
        this.currentExecutable = null;
        for (CtElement node : new ArrayList(this.callGraph.nodes())) {
            try {
                this.callGraph.removeNode((Object)node);
            }
            catch (IllegalStateException | NullPointerException e2) {
                logger.warn("Cannot remove node from CallGraph", (Throwable)e2);
            }
        }
        this.sorted.clear();
        this.endNodes.clear();
        this.externalMembers.clear();
        this.membersToSort.clear();
        elements.map(this::wrap).forEachOrdered(this.membersToSort::add);
        this.membersToSort.stream().map(Equivalence.Wrapper::get).forEach(arg_0 -> ((CallGraphVisitor)this).scan(arg_0));
        this.callGraph.nodes().stream().filter(n -> this.callGraph.predecessors(n).isEmpty()).forEachOrdered(this.endNodes::add);
        while (!this.endNodes.isEmpty()) {
            Set nodeSuccessors;
            CtElement n2 = this.endNodes.remove(this.endNodes.size() - 1);
            if (this.membersToSort.remove(this.wrap(n2))) {
                this.sorted.add(n2);
            }
            try {
                nodeSuccessors = this.callGraph.successors((Object)n2);
            }
            catch (IllegalArgumentException e3) {
                nodeSuccessors = null;
                logger.warn("Cannot get successors for node in " + ((Object)((Object)this)).getClass().getName(), (Throwable)e3);
            }
            if (nodeSuccessors == null) continue;
            for (CtElement m : new ArrayList(nodeSuccessors)) {
                this.callGraph.removeEdge((Object)n2, (Object)m);
                if (!this.callGraph.predecessors((Object)m).isEmpty()) continue;
                this.endNodes.add(m);
            }
        }
        this.membersToSort.forEach(e -> this.sorted.add((CtElement)e.get()));
    }

    public List<CtElement> getSorted() {
        return new ArrayList<CtElement>(this.sorted);
    }

    @NotNull
    public List<CtElement> getExternalMembers() {
        return this.externalMembers.stream().map(Equivalence.Wrapper::get).collect(Collectors.toList());
    }
}

