/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility.statistic;

import com.pvsstudio.utility.statistic.InvocationMetaInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.reference.CtExecutableReference;

public class InvocationStatistic {
    private final Map<CtExecutableReference<?>, List<InvocationMetaInfo>> invocationMetaInfoMap = new HashMap();
    private final Map<CtExecutableReference<?>, Integer> invocationCounterMap = new HashMap();

    public void clear() {
        this.invocationCounterMap.clear();
        this.invocationMetaInfoMap.clear();
    }

    public void addInvocation(@NotNull CtInvocation<?> invocation, boolean notUsedFlag, boolean exceptionFlag) {
        CtExecutableReference executableReference = invocation.getExecutable();
        if (!this.invocationCounterMap.containsKey(executableReference)) {
            this.invocationCounterMap.put(executableReference, 1);
            this.invocationMetaInfoMap.put(executableReference, new ArrayList());
        } else {
            this.invocationCounterMap.put(executableReference, this.invocationCounterMap.get(executableReference) + 1);
        }
        if (notUsedFlag) {
            this.invocationMetaInfoMap.get(executableReference).add(new InvocationMetaInfo(invocation, exceptionFlag));
        }
    }

    public boolean isEmpty() {
        return this.invocationCounterMap.isEmpty();
    }

    public void removeManyInvocationsInOneFile(int threshold) {
        for (CtExecutableReference<?> executable : this.invocationMetaInfoMap.keySet()) {
            Map groups = this.invocationMetaInfoMap.get(executable).stream().collect(Collectors.groupingBy(InvocationMetaInfo::getFile, Collectors.toList()));
            for (File file : groups.keySet()) {
                int invocationCountInOneFile = groups.get(file).size();
                if (invocationCountInOneFile <= threshold) continue;
                this.invocationMetaInfoMap.get(executable).removeAll(groups.get(file));
                this.invocationCounterMap.put(executable, this.invocationCounterMap.get(executable) - invocationCountInOneFile);
            }
        }
    }

    public List<CtInvocation<?>> getInvocationsWithoutReturn(double threshold) {
        ArrayList result = new ArrayList();
        for (CtExecutableReference<?> reference : this.invocationMetaInfoMap.keySet()) {
            List invocations = this.invocationMetaInfoMap.get(reference).stream().filter(Predicate.not(InvocationMetaInfo::isExceptionOfUsing)).map(InvocationMetaInfo::getInvocation).collect(Collectors.toList());
            if (!((double)invocations.size() / (double)this.invocationCounterMap.get(reference).intValue() <= threshold)) continue;
            result.addAll(invocations);
        }
        return result;
    }
}

