/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility.network;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Subnetwork {
    private final InetAddress network;
    private final byte[] networkBytes;
    private final int prefixLength;

    @NotNull
    public static Subnetwork forString(@NotNull String value) {
        String[] split = value.split("/", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("Got invalid ip address mask: " + value);
        }
        InetAddress address = InetAddresses.forString((String)split[0]);
        int prefixLength = Integer.parseInt(split[1]);
        return new Subnetwork(address, prefixLength);
    }

    public Subnetwork(@NotNull InetAddress network, int prefixLength) {
        Objects.requireNonNull(network, "network must not be null");
        this.network = network;
        this.networkBytes = network.getAddress();
        this.prefixLength = prefixLength;
    }

    public boolean isInRange(@NotNull InetAddress address) {
        byte[] addressBytes = address.getAddress();
        if (addressBytes.length != this.networkBytes.length) {
            return false;
        }
        int byteCount = this.prefixLength / 8;
        for (int i = 0; i < byteCount; ++i) {
            if (addressBytes[i] == this.networkBytes[i]) continue;
            return false;
        }
        int remainingBits = this.prefixLength % 8;
        if (remainingBits == 0) {
            return true;
        }
        byte mask = (byte)(255 << 8 - remainingBits);
        return (addressBytes[byteCount] & mask) == (this.networkBytes[byteCount] & mask);
    }

    @NotNull
    public InetAddress getNetwork() {
        return this.network;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subnetwork that = (Subnetwork)o;
        return this.prefixLength == that.prefixLength && Objects.equals(this.network, that.network);
    }

    public int hashCode() {
        return Objects.hash(this.network, this.prefixLength);
    }
}

