/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility.closeable;

import com.pvsstudio.utility.closeable.FieldMetaInfo;
import com.pvsstudio.utility.closeable.MethodMetaInfo;
import com.pvsstudio.utility.closeable.ResourceFieldRulePredicate;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class MatchesScanner {
    public static void scanMatches(@NotNull List<? extends CtVariableAccess<?>> variableAccesses, @NotNull CtClass<?> ctClass, @NotNull MethodMetaInfo checkingExecutable, @NotNull List<CtMethod<?>> methodsWithCloseArgument, @NotNull FieldMetaInfo variable) {
        int methodsWithCloseResourceInsideCount = variable.getMethodsWithFieldClosingInside().size();
        for (CtVariableAccess<?> variableAccess : variableAccesses) {
            CtLocalVariable ctLocalVariable;
            CtElement variableAccessParent = variableAccess.getParent();
            if (ResourceFieldRulePredicate.isInitializing(variableAccess)) {
                variable.withoutInitializingFlag = false;
                variable.notUsedFlag = false;
                boolean externalResource = ResourceFieldRulePredicate.isExternalResource(((CtAssignment)variableAccessParent).getAssignment(), checkingExecutable.getMethod(), ctClass);
                if (externalResource) {
                    variable.exceptionFlag = true;
                    return;
                }
            }
            if (ResourceFieldRulePredicate.isCloseMethodInvocation(variableAccessParent)) {
                variable.addMethod(checkingExecutable);
                variable.notUsedFlag = false;
                return;
            }
            if (ResourceFieldRulePredicate.isArgumentOfOtherClassMethod(variableAccess, ctClass) || checkingExecutable.getMethod() instanceof CtMethod && variableAccessParent instanceof CtReturn && !((CtMethod)checkingExecutable.getMethod()).isPrivate() || methodsWithCloseArgument.stream().anyMatch(x -> ResourceFieldRulePredicate.isArgumentOfMethod(x, variableAccessParent))) {
                variable.exceptionFlag = true;
                variable.notUsedFlag = false;
                return;
            }
            if (variableAccessParent instanceof CtLocalVariable && variableAccess instanceof CtFieldRead) {
                if (ResourceFieldRulePredicate.isUsingInTryWithResources(checkingExecutable.getMethod(), (CtLocalVariable)variableAccessParent)) {
                    variable.addMethod(checkingExecutable);
                    variable.notUsedFlag = false;
                    return;
                }
                MatchesScanner.scanMatches(MatchesScanner.findAllVariableUsagesInMethod(checkingExecutable.getMethod(), (CtLocalVariable)variableAccessParent), ctClass, checkingExecutable, methodsWithCloseArgument, variable);
                if (variable.exceptionFlag || methodsWithCloseResourceInsideCount != variable.getMethodsWithFieldClosingInside().size()) {
                    return;
                }
            }
            if ((ctLocalVariable = (CtLocalVariable)Optional.of(variableAccessParent).filter(CtAssignment.class::isInstance).map(CtAssignment.class::cast).filter(assignment -> assignment.getAssigned() instanceof CtVariableWrite).filter(assignment -> assignment.getAssignment() instanceof CtVariableRead).filter(assignment -> ((CtVariableRead)assignment.getAssignment()).equals((Object)variableAccess)).map(CtAssignment::getAssigned).map(CtVariableWrite.class::cast).map(CtVariableAccess::getVariable).map(CtVariableReference::getDeclaration).filter(CtLocalVariable.class::isInstance).map(CtLocalVariable.class::cast).orElse(null)) == null) continue;
            if (ResourceFieldRulePredicate.isUsingInTryWithResources(checkingExecutable.getMethod(), ctLocalVariable)) {
                variable.addMethod(checkingExecutable);
                variable.notUsedFlag = false;
                return;
            }
            MatchesScanner.scanMatches(MatchesScanner.findAllVariableUsagesInMethod(checkingExecutable.getMethod(), ctLocalVariable), ctClass, checkingExecutable, methodsWithCloseArgument, variable);
            if (!variable.exceptionFlag && methodsWithCloseResourceInsideCount == variable.getMethodsWithFieldClosingInside().size()) continue;
            return;
        }
    }

    @NotNull
    public static List<CtVariableAccess<?>> findAllVariableUsagesInMethod(@NotNull CtExecutable<?> method, final @NotNull CtVariable<?> checkingVariable) {
        return method.getElements((Filter)new TypeFilter<CtVariableAccess<?>>(CtVariableAccess.class){

            public boolean matches(CtVariableAccess<?> variableAccess) {
                return Optional.of(variableAccess).map(CtVariableAccess::getVariable).map(CtVariableReference::getDeclaration).filter(variable -> variable == checkingVariable || variable.equals((Object)checkingVariable)).isPresent();
            }
        });
    }

    @NotNull
    public static List<CtFieldAccess<?>> findAllFieldUsagesInExecutableWithFilter(@NotNull CtExecutable<?> executable, final @NotNull CtField<?> checkingField) {
        return executable.getElements((Filter)new TypeFilter<CtFieldAccess<?>>(CtFieldAccess.class){

            public boolean matches(CtFieldAccess<?> fieldAccess) {
                return Optional.of(fieldAccess).filter(fa -> !(fa.getTarget() instanceof CtVariableRead)).map(CtFieldAccess::getVariable).map(CtFieldReference::getFieldDeclaration).filter(field -> field == checkingField || field.equals((Object)checkingField)).isPresent();
            }
        });
    }

    @NotNull
    public static List<CtInvocation<?>> findMethodInvocationInOtherMethod(@NotNull MethodMetaInfo scanningExecutable, final @NotNull MethodMetaInfo searchingExecutable) {
        return scanningExecutable.getMethod().getElements((Filter)new TypeFilter<CtInvocation<?>>(CtInvocation.class){

            public boolean matches(CtInvocation<?> executable) {
                return Optional.of(executable).filter(x -> !searchingExecutable.isUsedWithThisInstance() || !(x.getTarget() instanceof CtVariableRead)).map(CtAbstractInvocation::getExecutable).map(CtExecutableReference::getDeclaration).filter(x -> x == searchingExecutable.getMethod() || x.equals(searchingExecutable.getMethod())).isPresent();
            }
        });
    }
}

