/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility.closeable;

import com.pvsstudio.utility.closeable.MethodMetaInfo;
import com.pvsstudio.utility.closeable.ResourceFieldRulePredicate;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;

public class FieldMetaInfo {
    @NotNull
    protected final CtField<?> field;
    protected boolean withoutInitializingFlag;
    protected boolean notUsedFlag;
    protected boolean exceptionFlag;
    private final Set<MethodMetaInfo> methodsWithCloseInsideField = new HashSet<MethodMetaInfo>();

    public FieldMetaInfo(@NotNull CtField<?> field, @NotNull CtClass<?> fieldOwner) {
        this.field = field;
        this.notUsedFlag = this.withoutInitializingFlag = !ResourceFieldRulePredicate.isInitializingOutMethod(field, fieldOwner);
    }

    public boolean isNotUsed() {
        return this.notUsedFlag;
    }

    public boolean isException() {
        return this.exceptionFlag;
    }

    @NotNull
    public CtField<?> getField() {
        return this.field;
    }

    public boolean isInitialized() {
        return !this.withoutInitializingFlag;
    }

    public void addMethod(@NotNull MethodMetaInfo method) {
        this.methodsWithCloseInsideField.add(method);
    }

    public Set<MethodMetaInfo> getMethodsWithFieldClosingInside() {
        return this.methodsWithCloseInsideField;
    }

    public boolean isClosed() {
        return !this.methodsWithCloseInsideField.isEmpty();
    }
}

