/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility.closeable;

import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.utility.GeneralUtils;
import com.pvsstudio.utility.TypeArchitectureScanner;
import com.pvsstudio.utility.closeable.FieldMetaInfo;
import com.pvsstudio.utility.closeable.MatchesScanner;
import com.pvsstudio.utility.closeable.MethodMetaInfo;
import com.pvsstudio.utility.closeable.ResourceFieldRulePredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class CloseableFieldsAnalyzer {
    @NotNull
    private final CtClass<?> owner;
    @NotNull
    private final List<CtMethod<?>> methodsWithClosingArgumentsInside;
    @NotNull
    private final List<FieldMetaInfo> fieldsWithCloseableInterface;
    private static final Set<Matcher<CtTypeReference<?>>> complexCloseMethods = Set.of(Matcher.ofClass((String)"java.nio.channels.spi.AbstractInterruptibleChannel").build(), Matcher.ofClass((String)"java.nio.channels.spi.AbstractSelectableChannel").build(), Matcher.ofClass((String)"java.nio.channels.spi.AbstractSelector").build(), Matcher.ofClass((String)"java.nio.channels.DatagramChannel").build(), Matcher.ofClass((String)"java.nio.channels.SelectableChannel").build(), Matcher.ofClass((String)"java.nio.channels.ServerSocketChannel").build(), Matcher.ofClass((String)"java.nio.channels.SocketChannel").build(), Matcher.ofClass((String)"java.nio.channels.FileChannel").build(), Matcher.ofClass((String)"java.nio.channels.Pipe.SinkChannel").build(), Matcher.ofClass((String)"java.nio.channels.Pipe.SourceChannel").build(), Matcher.ofClass((String)"java.io.BufferedInputStream").build(), Matcher.ofClass((String)"java.io.BufferedOutputStream").build(), Matcher.ofClass((String)"java.io.BufferedWriter").build(), Matcher.ofClass((String)"java.io.CharArrayReader").build(), Matcher.ofClass((String)"java.io.DataOutputStream").build(), Matcher.ofClass((String)"java.io.Scanner").build(), Matcher.ofClass((String)"java.io.PrintStream").build(), Matcher.ofClass((String)"java.io.PrintWriter").build(), Matcher.ofClass((String)"java.io.ObjectOutputStream").build(), Matcher.ofClass((String)"java.io.BufferedReader").build(), Matcher.ofClass((String)"java.io.FileInputStream").build(), Matcher.ofClass((String)"java.io.FileOutputStream").build(), Matcher.ofClass((String)"java.io.FileReader").build(), Matcher.ofClass((String)"java.io.FileWriter").build(), Matcher.ofClass((String)"java.io.FilterOutputStream").build(), Matcher.ofClass((String)"java.io.FilterWriter").build(), Matcher.ofClass((String)"java.io.ObjectInputStream").build(), Matcher.ofClass((String)"java.io.OutputStreamWriter").build(), Matcher.ofClass((String)"java.io.PipedInputStream").build(), Matcher.ofClass((String)"java.io.PipedOutputStream").build(), Matcher.ofClass((String)"java.io.PipedReader").build(), Matcher.ofClass((String)"java.io.PipedWriter").build(), Matcher.ofClass((String)"java.io.InputStreamReader").build(), Matcher.ofClass((String)"java.io.LineNumberReader").build(), Matcher.ofClass((String)"java.io.PushbackInputStream").build(), Matcher.ofClass((String)"java.io.PushbackReader").build(), Matcher.ofClass((String)"java.io.RandomAccessFile").build(), Matcher.ofClass((String)"java.io.StringReader").build(), Matcher.ofClass((String)"java.io.SequenceInputStream").build(), Matcher.ofClass((String)"java.util.Formatter").build(), Matcher.ofClass((String)"java.util.jar.JarFile").build(), Matcher.ofClass((String)"java.util.jar.JarInputStream").build(), Matcher.ofClass((String)"java.util.jar.JarOutputStream").build(), Matcher.ofClass((String)"java.util.zip.CheckedOutputStream").build(), Matcher.ofClass((String)"java.util.zip.DeflaterInputStream").build(), Matcher.ofClass((String)"java.util.zip.DeflaterOutputStream").build(), Matcher.ofClass((String)"java.util.zip.GZIPInputStream").build(), Matcher.ofClass((String)"java.util.zip.GZIPOutputStream").build(), Matcher.ofClass((String)"java.util.zip.InflaterInputStream").build(), Matcher.ofClass((String)"java.util.zip.InflaterOutputStream").build(), Matcher.ofClass((String)"java.util.zip.ZipFile").build(), Matcher.ofClass((String)"java.util.zip.ZipInputStream").build(), Matcher.ofClass((String)"java.util.zip.ZipOutputStream").build(), Matcher.ofClass((String)"java.net.ServerSocket").build(), Matcher.ofClass((String)"java.net.Socket").build(), Matcher.ofClass((String)"java.net.URLClassLoader").build(), Matcher.ofClass((String)"java.net.DatagramSocket").build(), Matcher.ofClass((String)"java.net.MulticastSocket").build(), Matcher.ofClass((String)"java.security.DigestOutputStream").build(), Matcher.ofClass((String)"java.rmi.server.LogStream").build(), Matcher.ofClass((String)"javax.net.ssl.SSLServerSocket").build(), Matcher.ofClass((String)"javax.net.ssl.SSLSocket").build(), Matcher.ofClass((String)"javax.sound.sampled.AudioInputStream").build(), Matcher.ofClass((String)"javax.swing.ProgressMonitorInputStream").build(), Matcher.ofClass((String)"javax.crypto.CipherInputStream").build(), Matcher.ofClass((String)"javax.crypto.CipherOutputStream").build(), Matcher.ofClass((String)"javax.imageio.stream.FileCacheImageInputStream").build(), Matcher.ofClass((String)"javax.imageio.stream.FileCacheImageOutputStream").build(), Matcher.ofClass((String)"javax.imageio.stream.FileImageInputStream").build(), Matcher.ofClass((String)"javax.imageio.stream.FileImageOutputStream").build(), Matcher.ofClass((String)"javax.imageio.stream.ImageInputStreamImpl").build(), Matcher.ofClass((String)"javax.imageio.stream.ImageOutputStreamImpl").build(), Matcher.ofClass((String)"javax.imageio.stream.MemoryCacheImageInputStream").build(), Matcher.ofClass((String)"javax.imageio.stream.MemoryCacheImageOutputStream").build(), Matcher.ofClass((String)"javax.management.loading.MLet").build(), Matcher.ofClass((String)"javax.management.loading.PrivateMLet").build(), Matcher.ofClass((String)"javax.management.remote.rmi.RMIConnectionImpl").build(), Matcher.ofClass((String)"javax.management.remote.rmi.RMIConnectionImpl_Stub").build(), Matcher.ofClass((String)"javax.management.remote.rmi.RMIConnector").build(), Matcher.ofClass((String)"javax.management.remote.rmi.RMIIIOPServerImpl").build(), Matcher.ofClass((String)"javax.management.remote.rmi.RMIJRMPServerImpl").build(), Matcher.ofClass((String)"javax.management.remote.rmi.RMIServerImpl ").build());
    private byte searchDepth = 0;
    @NotNull
    protected static final String[] SEARCHING_INTERFACES = new String[]{"java.io.Closeable", "java.lang.AutoCloseable"};

    public CloseableFieldsAnalyzer(@NotNull CtClass<?> owner) {
        this.owner = owner;
        this.fieldsWithCloseableInterface = new ArrayList<FieldMetaInfo>();
        this.methodsWithClosingArgumentsInside = new ArrayList();
    }

    public CloseableFieldsAnalyzer(@NotNull CtClass<?> owner, byte searchDepth) {
        this(owner);
        if (searchDepth >= 0) {
            this.searchDepth = searchDepth;
        }
    }

    public boolean areNoCloseableFields() {
        return this.fieldsWithCloseableInterface.isEmpty();
    }

    @NotNull
    public List<FieldMetaInfo> getCloseableFields() {
        return this.fieldsWithCloseableInterface;
    }

    private void scanFieldAccessesInExecutables(@NotNull FieldMetaInfo field, @NotNull List<MethodMetaInfo> executables) {
        for (MethodMetaInfo executable : executables) {
            MatchesScanner.scanMatches(MatchesScanner.findAllFieldUsagesInExecutableWithFilter(executable.getMethod(), field.getField()), this.owner, executable, this.methodsWithClosingArgumentsInside, field);
        }
    }

    private List<FieldMetaInfo> scanExecutables(@NotNull List<MethodMetaInfo> allClassExecutables) {
        ArrayList<FieldMetaInfo> fieldsToRemove = new ArrayList<FieldMetaInfo>();
        ArrayList<FieldMetaInfo> notUsedFields = new ArrayList<FieldMetaInfo>();
        for (FieldMetaInfo field : this.fieldsWithCloseableInterface) {
            this.scanFieldAccessesInExecutables(field, allClassExecutables);
            if (field.isException()) {
                fieldsToRemove.add(field);
                continue;
            }
            if (!field.isNotUsed()) continue;
            notUsedFields.add(field);
        }
        this.fieldsWithCloseableInterface.removeAll(fieldsToRemove);
        return notUsedFields;
    }

    private boolean isMethodWithClosingInsideArgument(@NotNull CtMethod<?> method) {
        if (method.getParameters().isEmpty()) {
            return false;
        }
        List parameters = method.getParameters().stream().filter(x -> x.getType().getTypeDeclaration() != null).filter(x -> CloseableFieldsAnalyzer.hasCloseableInterface(x.getType(), true)).collect(Collectors.toList());
        if (parameters.isEmpty()) {
            return false;
        }
        return parameters.stream().filter(parameter -> MatchesScanner.findAllVariableUsagesInMethod(method, parameter).stream().filter(parameterAccessMatch -> !ResourceFieldRulePredicate.isInitializing(parameterAccessMatch)).anyMatch(parameterAccessMatch -> ResourceFieldRulePredicate.isCloseMethodInvocation(parameterAccessMatch.getParent()))).count() == (long)parameters.size();
    }

    @NotNull
    private List<CtField<?>> findFieldsWithCloseableInterface(@NotNull CtClass<?> ctClass) {
        return ctClass.getFields().stream().filter(Predicate.not(CtModifiable::isStatic)).filter(CtModifiable::isPrivate).filter(field -> field.getType().isClass() || field.getType().isInterface()).filter(field -> CloseableFieldsAnalyzer.hasCloseableInterface(field.getType(), true)).filter(field -> field.getType().getTypeDeclaration().isAbstract() || field.getType().isInterface() || field.getType().isClass() && !CloseableFieldsAnalyzer.isEmptyCloseMethod(field.getType().getTypeDeclaration())).collect(Collectors.toList());
    }

    public static boolean isEmptyCloseMethod(@NotNull CtType<?> ctClass) {
        CtTypeReference superClass;
        do {
            if (ctClass.getPosition() instanceof NoSourcePosition) {
                CtTypeReference reference = ctClass.getReference();
                return complexCloseMethods.stream().noneMatch(matcher -> matcher.matches((CtElement)reference));
            }
            CtMethod<?> closeMethod = CloseableFieldsAnalyzer.findCloseMethod(ctClass);
            if (closeMethod == null || closeMethod.getBody() == null) continue;
            return closeMethod.getBody().getStatements().isEmpty();
        } while ((superClass = ctClass.getSuperclass()) != null && (ctClass = superClass.getTypeDeclaration()) != null);
        return true;
    }

    @Nullable
    public static CtMethod<?> findCloseMethod(@NotNull CtType<?> ctClass) {
        return ctClass.getMethods().stream().filter(ResourceFieldRulePredicate::isCloseMethod).findFirst().orElse(null);
    }

    public static boolean hasCloseableInterface(@NotNull CtTypeReference<?> typeInformation, boolean checkSuperTypes) {
        TypeArchitectureScanner.Config config = new TypeArchitectureScanner.Config().setInterfaceScanningEnableFlag(true).setParentClassesScanningEnableFlag(checkSuperTypes).setParentInterfacesScanningEnableFlag(checkSuperTypes);
        TypeArchitectureScanner<Boolean> scanner = new TypeArchitectureScanner<Boolean>(config){

            @Override
            protected void visitInterface(CtTypeReference<?> ctInterface) {
                if (Arrays.stream(SEARCHING_INTERFACES).anyMatch(x -> x.equals(ctInterface.getQualifiedName()))) {
                    this.setResult(true);
                    this.terminate();
                }
            }
        };
        scanner.scan(typeInformation);
        return scanner.getResult() != null && (Boolean)scanner.getResult() != false;
    }

    private void deleteFieldsWithUsingAsArgumentsOutOfMethods() {
        ArrayList<FieldMetaInfo> fieldsToDelete = new ArrayList<FieldMetaInfo>();
        for (FieldMetaInfo fieldMetaInfo : this.fieldsWithCloseableInterface) {
            for (CtField field : this.owner.getFields()) {
                CtAbstractInvocation abstractInvocation;
                CtExpression fieldInitExpression = field.getAssignment();
                if (!(fieldInitExpression instanceof CtAbstractInvocation) || !(abstractInvocation = (CtAbstractInvocation)field.getAssignment()).getArguments().stream().filter(argument -> argument instanceof CtFieldRead).map(argument -> ((CtFieldRead)argument).getVariable()).anyMatch(fieldReference -> fieldReference == fieldMetaInfo.getField().getReference() || fieldReference.equals((Object)fieldMetaInfo.getField().getReference()))) continue;
                fieldsToDelete.add(fieldMetaInfo);
            }
        }
        this.fieldsWithCloseableInterface.removeAll(fieldsToDelete);
    }

    public void scan() {
        ArrayList allClassExecutables = new ArrayList();
        allClassExecutables.addAll(this.owner.getAnonymousExecutables());
        allClassExecutables.addAll(this.owner.getConstructors());
        allClassExecutables.addAll(this.owner.getMethods());
        List<MethodMetaInfo> methodMetaInfoList = allClassExecutables.stream().map(x -> new MethodMetaInfo((CtExecutable<?>)x, true)).collect(Collectors.toList());
        List<FieldMetaInfo> notUsedFields = this.scanExecutables(methodMetaInfoList);
        this.fieldsWithCloseableInterface.forEach(x -> this.scanInvocationChain((FieldMetaInfo)x, methodMetaInfoList, this.searchDepth));
        List innerClasses = this.owner.getTypeMembers().stream().filter(CtClass.class::isInstance).map(typeMember -> (CtClass)typeMember).filter(Predicate.not(CtModifiable::isStatic)).collect(Collectors.toList());
        for (CtClass innerClass : innerClasses) {
            ArrayList allInnerClassExecutables = new ArrayList();
            allInnerClassExecutables.addAll(innerClass.getAnonymousExecutables());
            allInnerClassExecutables.addAll(innerClass.getConstructors());
            allInnerClassExecutables.addAll(innerClass.getMethods());
            List<MethodMetaInfo> listOfInnerClassesMethodsMetaInfo = allInnerClassExecutables.stream().map(x -> new MethodMetaInfo((CtExecutable<?>)x, false)).collect(Collectors.toList());
            notUsedFields = GeneralUtils.getListIntersection(notUsedFields, this.scanExecutables(listOfInnerClassesMethodsMetaInfo));
            this.fieldsWithCloseableInterface.forEach(x -> this.scanInvocationChain((FieldMetaInfo)x, listOfInnerClassesMethodsMetaInfo, this.searchDepth));
        }
        this.fieldsWithCloseableInterface.forEach(x -> this.scanInvocationChain((FieldMetaInfo)x, methodMetaInfoList, this.searchDepth));
        this.getCloseableFields().removeAll(notUsedFields);
        this.getCloseableFields().removeAll(this.getCloseableFields().stream().filter(Predicate.not(FieldMetaInfo::isInitialized)).collect(Collectors.toList()));
        this.deleteFieldsWithUsingAsArgumentsOutOfMethods();
    }

    public void findCloseableFields() {
        this.fieldsWithCloseableInterface.addAll(this.findFieldsWithCloseableInterface(this.owner).stream().map(x -> new FieldMetaInfo((CtField<?>)x, this.owner)).collect(Collectors.toList()));
    }

    public void findMethodsThatCloseArgument() {
        this.methodsWithClosingArgumentsInside.addAll(this.owner.getMethods().stream().filter(this::isMethodWithClosingInsideArgument).collect(Collectors.toList()));
    }

    private void scanInvocationChain(@NotNull FieldMetaInfo field, @NotNull List<MethodMetaInfo> executables, byte depth) {
        if (depth <= 0) {
            return;
        }
        byte counter = 0;
        do {
            for (MethodMetaInfo scanningExecutable : executables) {
                if (!field.getMethodsWithFieldClosingInside().stream().filter(x -> x.getMethod() != scanningExecutable.getMethod() && !x.getMethod().equals(scanningExecutable.getMethod())).anyMatch(x -> !MatchesScanner.findMethodInvocationInOtherMethod(scanningExecutable, x).isEmpty())) continue;
                field.addMethod(scanningExecutable);
            }
        } while ((counter = (byte)((byte)(counter + 1))) < depth);
    }

    public static boolean isTypeHaveDefaultOrFinalCloseInHierarchy(@NotNull CtClass<?> ctClass, @Nullable CtMethod<?> closeMethodOfClass) {
        if (closeMethodOfClass != null) {
            return false;
        }
        final MutableBoolean typeHaveFinalCloseMethod = new MutableBoolean(false);
        TypeArchitectureScanner.Config config = new TypeArchitectureScanner.Config().setInterfaceScanningEnableFlag(false).setParentClassesScanningEnableFlag(true).setParentInterfacesScanningEnableFlag(false);
        TypeArchitectureScanner<Boolean> scanner = new TypeArchitectureScanner<Boolean>(config){

            @Override
            protected void visitClass(CtTypeReference<?> ctClass) {
                Optional<CtExecutableReference> closeMethodOptional = ctClass.getDeclaredExecutables().stream().filter(method -> ResourceFieldRulePredicate.isCloseMethod(method.getExecutableDeclaration().getReference())).findFirst();
                if (closeMethodOptional.isPresent()) {
                    this.setResult(true);
                    typeHaveFinalCloseMethod.setValue(closeMethodOptional.get().isFinal());
                    this.terminate();
                }
            }
        };
        scanner.scan(ctClass.getReference());
        return scanner.getResult() == null || typeHaveFinalCloseMethod.isTrue();
    }
}

