/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.reference.CtTypeReference;

public class TypeArchitectureScanner<T> {
    private T result = null;
    private final boolean scanInterfaceFlag;
    private final boolean scanParentClassesFlag;
    private final boolean scanParentInterfacesFlag;
    private boolean terminate = false;
    private final Set<CtTypeReference<?>> qualifiedInterfaces = new HashSet();

    protected final void terminate() {
        this.terminate = true;
    }

    @Nullable
    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public TypeArchitectureScanner(Config config) {
        this.scanInterfaceFlag = config.scanInterfaceFlag;
        this.scanParentClassesFlag = config.scanParentClassesFlag;
        this.scanParentInterfacesFlag = config.scanParentInterfacesFlag;
    }

    public final void scan(CtTypeReference<?> typeInformation) {
        if (typeInformation == null || typeInformation.isPrimitive()) {
            return;
        }
        if (typeInformation.isClass() || typeInformation.isEnum()) {
            this.scanClasses(typeInformation);
        }
        if (typeInformation.isInterface()) {
            this.scanInterfaces(typeInformation);
        }
        this.qualifiedInterfaces.clear();
        this.terminate = false;
    }

    private void scanClasses(CtTypeReference<?> classReference) {
        do {
            if (classReference.isEnum()) {
                this.visitEnum(classReference);
            } else {
                this.visitClass(classReference);
            }
            if (this.terminate) break;
            if (this.scanInterfaceFlag) {
                classReference.getSuperInterfaces().forEach(this::scanInterfaces);
            }
            classReference = classReference.getSuperclass();
        } while (!this.terminate && this.scanParentClassesFlag && classReference != null);
    }

    private void scanInterfaces(CtTypeReference<?> interfaceReference) {
        ArrayList superInterfaces = new ArrayList();
        superInterfaces.add(interfaceReference);
        do {
            ArrayList newSuperInterfaces = new ArrayList();
            for (CtTypeReference ctTypeReference : superInterfaces) {
                if (this.qualifiedInterfaces.contains(ctTypeReference)) continue;
                this.visitInterface(ctTypeReference);
                if (this.terminate) break;
                this.qualifiedInterfaces.add(ctTypeReference);
                newSuperInterfaces.addAll(ctTypeReference.getSuperInterfaces());
            }
            superInterfaces = newSuperInterfaces;
        } while (!this.terminate && this.scanParentInterfacesFlag && !superInterfaces.isEmpty());
    }

    protected void visitInterface(CtTypeReference<?> ctInterface) {
    }

    protected void visitClass(CtTypeReference<?> ctClass) {
    }

    protected void visitEnum(CtTypeReference<?> ctEnum) {
    }

    public static class Config {
        private boolean scanInterfaceFlag = true;
        private boolean scanParentClassesFlag = true;
        private boolean scanParentInterfacesFlag = true;

        public final Config setInterfaceScanningEnableFlag(boolean flag) {
            this.scanInterfaceFlag = flag;
            return this;
        }

        public final Config setParentClassesScanningEnableFlag(boolean flag) {
            this.scanParentClassesFlag = flag;
            return this;
        }

        public final Config setParentInterfacesScanningEnableFlag(boolean flag) {
            this.scanParentInterfacesFlag = flag;
            return this;
        }
    }
}

