/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility;

import com.pvsstudio.AnalyzerConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ProjectUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProjectType guessProjectType(@NotNull AnalyzerConfig config) {
        try (Stream<Path> filesStream = Files.list(Path.of(config.projectPath, new String[0]));){
            List files = filesStream.collect(Collectors.toList());
            if (files.stream().anyMatch(file -> file.getFileName().toString().startsWith("pom.xml"))) {
                ProjectType projectType = ProjectType.MAVEN;
                return projectType;
            }
            if (!files.stream().map(path -> path.getFileName().toString()).anyMatch(file -> file.startsWith("settings.gradle") || file.startsWith("build.gradle"))) return ProjectType.UNKNOWN;
            ProjectType projectType = ProjectType.GRADLE;
            return projectType;
        }
        catch (IOException ex) {
            return ProjectType.UNKNOWN;
        }
    }

    public static enum ProjectType {
        MAVEN,
        GRADLE,
        UNKNOWN;

    }
}

