/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utility;

import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtField;

public final class LanguageUtility {
    private LanguageUtility() {
        throw new IllegalStateException("utility class");
    }

    public static boolean isConstantExpression(CtExpression<?> expr) {
        if (expr instanceof CtLiteral) {
            return true;
        }
        if (expr instanceof CtUnaryOperator) {
            CtUnaryOperator operator = (CtUnaryOperator)expr;
            return operator.getKind() != UnaryOperatorKind.POSTINC && operator.getKind() != UnaryOperatorKind.POSTDEC && operator.getKind() != UnaryOperatorKind.PREINC && operator.getKind() != UnaryOperatorKind.PREDEC && LanguageUtility.isConstantExpression(operator.getOperand());
        }
        if (expr instanceof CtBinaryOperator) {
            CtBinaryOperator operator = (CtBinaryOperator)expr;
            return operator.getKind() != BinaryOperatorKind.INSTANCEOF && LanguageUtility.isConstantExpression(operator.getLeftHandOperand()) && LanguageUtility.isConstantExpression(operator.getRightHandOperand());
        }
        if (expr instanceof CtConditional) {
            CtConditional operator = (CtConditional)expr;
            return LanguageUtility.isConstantExpression(operator.getCondition()) && LanguageUtility.isConstantExpression(operator.getThenExpression()) && LanguageUtility.isConstantExpression(operator.getElseExpression());
        }
        if (expr instanceof CtFieldRead) {
            CtFieldRead fieldRead = (CtFieldRead)expr;
            CtField declaration = fieldRead.getVariable().getDeclaration();
            return declaration != null && declaration.isFinal() && declaration.getDefaultExpression() != null && LanguageUtility.isConstantExpression(declaration.getDefaultExpression());
        }
        return false;
    }
}

